/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.attribute;

import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.AttributeIsPresent;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueContains;
import org.jboss.arquillian.graphene.condition.attribute.AttributeValueEquals;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocatorAttributeConditionFactory
extends AbstractBooleanConditionFactory<AttributeConditionFactory>
implements AttributeConditionFactory {
    private final By locator;
    private final String attribute;

    public LocatorAttributeConditionFactory(By locator, String attribute) {
        this.locator = locator;
        this.attribute = attribute;
    }

    @Override
    public ExpectedCondition<Boolean> valueContains(String expected) {
        return this.contains(expected);
    }

    @Override
    public ExpectedCondition<Boolean> valueEquals(String expected) {
        return this.equalTo(expected);
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return new AttributeIsPresent(driver.findElement(LocatorAttributeConditionFactory.this.locator), LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.getNegation()).apply(driver);
            }

            public String toString() {
                return String.format("attribute ('%s')%s to be present in element %s", LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.getNegation() ? " not" : "", LocatorAttributeConditionFactory.this.locator.toString());
            }
        };
    }

    @Override
    public ExpectedCondition<Boolean> contains(final String expected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return new AttributeValueContains(driver.findElement(LocatorAttributeConditionFactory.this.locator), LocatorAttributeConditionFactory.this.attribute, expected, LocatorAttributeConditionFactory.this.getNegation()).apply(driver);
            }

            public String toString() {
                return String.format("text ('%s')%s to be contained by value of attribute ('%s') in element %s", expected, LocatorAttributeConditionFactory.this.getNegation() ? " not" : "", LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.locator.toString());
            }
        };
    }

    @Override
    public ExpectedCondition<Boolean> equalTo(final String expected) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return new AttributeValueEquals(driver.findElement(LocatorAttributeConditionFactory.this.locator), LocatorAttributeConditionFactory.this.attribute, expected, LocatorAttributeConditionFactory.this.getNegation()).apply(driver);
            }

            public String toString() {
                return String.format("text ('%s')%s to be equal to value of attribute ('%s') in element %s", expected, LocatorAttributeConditionFactory.this.getNegation() ? " not" : "", LocatorAttributeConditionFactory.this.attribute, LocatorAttributeConditionFactory.this.locator.toString());
            }
        };
    }

    @Override
    protected AttributeConditionFactory copy() {
        return new LocatorAttributeConditionFactory(this.locator, this.attribute);
    }
}

