/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.PageObjectInitializationException;
import org.jboss.arquillian.graphene.spi.annotations.Page;
import org.openqa.selenium.SearchContext;

public class PageObjectEnricher
extends AbstractSearchContextEnricher {
    @Inject
    private Instance<ServiceLoader> serviceLoader;

    public void enrich(SearchContext searchContext, Object target) {
        String errorMsgBegin = "";
        List<Field> fields = ReflectionHelper.getFieldsWithAnnotation(target.getClass(), Page.class);
        for (Field field : fields) {
            try {
                Type type = field.getGenericType();
                Class<?> declaredClass = type instanceof TypeVariable ? this.getActualType(field, target) : field.getType();
                errorMsgBegin = "Can not instantiate Page Object " + NEW_LINE + declaredClass + NEW_LINE + " declared in: " + NEW_LINE + target.getClass().getName() + NEW_LINE;
                Object page = this.instantiate(declaredClass);
                this.enrichRecursively(searchContext, page);
                this.setValue(field, target, page);
            }
            catch (NoSuchMethodException ex) {
                throw new PageObjectInitializationException(errorMsgBegin + " Check whether declared Page Object has no argument constructor!", ex);
            }
            catch (IllegalAccessException ex) {
                throw new PageObjectInitializationException(" Check whether declared Page Object has public no argument constructor!", ex);
            }
            catch (InstantiationException ex) {
                throw new PageObjectInitializationException(errorMsgBegin + " Check whether you did not declare Page Object with abstract type!", ex);
            }
            catch (Exception ex) {
                throw new PageObjectInitializationException(errorMsgBegin, ex);
            }
        }
    }
}

