/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher.findby;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GraphenePageExtensionsContext;
import org.jboss.arquillian.graphene.page.extension.JQueryPageExtension;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByJQuery
extends By {
    private String jquerySelector;
    private JavascriptExecutor executor = (JavascriptExecutor)GrapheneContext.getProxyForInterfaces(JavascriptExecutor.class);

    public ByJQuery(String jquerySelector) {
        this.jquerySelector = jquerySelector.replaceAll("\\\"", "\\\\\"");
    }

    public static ByJQuery jquerySelector(String selector) {
        if (selector == null) {
            throw new IllegalArgumentException("Cannot find elements when jquerySelector is null!");
        }
        return new ByJQuery(selector);
    }

    public String toString() {
        return "By.jquerySelector " + this.jquerySelector;
    }

    public List<WebElement> findElements(SearchContext context) {
        this.installJQueryExtension();
        List<Object> elements = new ArrayList<WebElement>();
        try {
            if (context instanceof WebElement) {
                elements = (List)this.executor.executeScript("return Graphene.jQuery(\"" + this.jquerySelector + "\", arguments[0]).get()", new Object[]{(WebElement)context});
            } else if (context instanceof WebDriver) {
                elements = (List)this.executor.executeScript("return Graphene.jQuery(\"" + this.jquerySelector + "\").get()", new Object[0]);
            } else {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, "Cannot determine the SearchContext you are passing to the findBy/s method! It is not instance of WebDriver nor WebElement! It is: " + context);
            }
        }
        catch (Exception ex) {
            throw new WebDriverException("Can not locate element using selector " + this.jquerySelector + " Check out whether it is correct!", (Throwable)ex);
        }
        return elements;
    }

    public WebElement findElement(SearchContext context) {
        this.installJQueryExtension();
        List<WebElement> elements = this.findElements(context);
        if (elements == null || elements.size() == 0) {
            throw new NoSuchElementException("Cannot locate element using: " + this.jquerySelector);
        }
        return elements.get(0);
    }

    private void installJQueryExtension() {
        JQueryPageExtension pageExtension = new JQueryPageExtension();
        GraphenePageExtensionsContext.getRegistryProxy().register(pageExtension);
        GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(pageExtension.getName()).install();
    }
}

