/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import com.google.common.io.Resources;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.context.GraphenePageExtensionsContext;
import org.jboss.arquillian.graphene.javascript.ExecutionResolver;
import org.jboss.arquillian.graphene.javascript.JSCall;
import org.jboss.arquillian.graphene.javascript.JSInterfaceHandler;
import org.jboss.arquillian.graphene.javascript.JSTarget;
import org.jboss.arquillian.graphene.javascript.JavaScriptUtils;
import org.jboss.arquillian.graphene.page.extension.JavaScriptPageExtension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutionResolver
implements ExecutionResolver {
    public static final String FUNCTION;
    public static final String CALL = "return invokeInterface({0}, \"{1}\", arguments);";
    protected static final Logger LOGGER;
    private JavascriptExecutor browser = (JavascriptExecutor)GrapheneContext.getProxyForInterfaces(JavascriptExecutor.class);

    @Override
    public Object execute(WebDriver driver, JSCall call) {
        if (driver == null) {
            throw new IllegalArgumentException("Driver can't be null.");
        }
        if (!(driver instanceof JavascriptExecutor)) {
            throw new IllegalArgumentException("The executor can be used only for drivers implementing " + JavascriptExecutor.class.getName());
        }
        JSTarget target = call.getTarget();
        if (target.getName() == null) {
            throw new IllegalStateException("Can't use " + this.getClass() + " for " + target.getInterface() + ", because the @JavaScript annotation doesn't define non empty value()");
        }
        this.registerExtension(target);
        GraphenePageExtensionsContext.getInstallatorProviderProxy().installator(target.getName()).install();
        Object returnValue = this.executeScriptForCall(call);
        Object castedResult = this.castResult(call, returnValue);
        return castedResult;
    }

    protected Object[] castArguments(Object[] arguments) {
        Object[] result = Arrays.copyOf(arguments, arguments.length);
        for (int i = 0; i < result.length; ++i) {
            Object arg = result[i];
            if (!arg.getClass().isEnum()) continue;
            result[i] = this.castEnumToString(arg);
        }
        return result;
    }

    protected Object castResult(JSCall call, Object returnValue) {
        Class<?> returnType = call.getMethod().getMethod().getReturnType();
        if (returnType.isEnum()) {
            return this.castStringToEnum(returnType, returnValue);
        }
        return returnValue;
    }

    protected Object castEnumToString(Object enumValue) {
        return enumValue.toString();
    }

    protected Object castStringToEnum(Class<?> returnType, Object returnValue) {
        try {
            Method method = returnType.getMethod("valueOf", String.class);
            return method.invoke(null, returnValue.toString());
        }
        catch (Exception e) {
            throw new IllegalStateException("returnValue '" + returnValue + "' can't be cast to enum value", e);
        }
    }

    protected Object executeScriptForCall(JSCall call) {
        String script = this.resolveScriptToExecute(call);
        Object[] arguments = this.castArguments(call.getArguments());
        Object returnValue = JavaScriptUtils.execute(this.browser, script, arguments);
        return returnValue;
    }

    protected String resolveScriptToExecute(JSCall call) {
        String functionCall = MessageFormat.format(CALL, call.getTarget().getName(), call.getMethod().getName());
        String functionDefinitionWithCall = FUNCTION + functionCall;
        return functionDefinitionWithCall;
    }

    protected <T> void registerExtension(JSTarget target) {
        if (target.getName() == null || target.getName().isEmpty()) {
            throw new IllegalArgumentException("The extension " + target.getInterface() + "has no mapping.");
        }
        if (GraphenePageExtensionsContext.getRegistryProxy().getExtension(target.getName()) != null) {
            return;
        }
        JavaScriptPageExtension extension = new JavaScriptPageExtension(target.getInterface());
        GraphenePageExtensionsContext.getRegistryProxy().register(extension);
        for (JSTarget dependency : target.getJSInterfaceDependencies()) {
            this.registerExtension(dependency);
        }
    }

    static {
        LOGGER = Logger.getLogger(DefaultExecutionResolver.class.getName());
        try {
            URL resource = JSInterfaceHandler.class.getResource("call.js");
            FUNCTION = Resources.toString((URL)resource, (Charset)Charset.defaultCharset());
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }
}

