/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import org.jboss.arquillian.graphene.proxy.ClassImposterizer;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrapheneProxy {
    public static boolean isProxyInstance(Object target) {
        return target instanceof GrapheneProxyInstance;
    }

    public static <T> T getProxyForTarget(T target) {
        if (Modifier.isFinal(target.getClass().getModifiers())) {
            if (target.getClass().getInterfaces().length > 0) {
                return GrapheneProxy.getProxyForTargetWithInterfaces(target, target.getClass().getInterfaces());
            }
            throw new IllegalStateException("Can't create a proxy for " + target.getClass() + ", it's final and id doesn't implement any interface.");
        }
        GrapheneProxyHandler handler = GrapheneProxyHandler.forTarget(target);
        return (T)GrapheneProxy.createProxy(handler, target.getClass(), new Class[0]);
    }

    public static <T> T getProxyForTargetWithInterfaces(T target, Class<?> ... interfaces) {
        GrapheneProxyHandler handler = GrapheneProxyHandler.forTarget(target);
        return GrapheneProxy.createProxy(handler, null, interfaces);
    }

    public static <T> T getProxyForFutureTarget(FutureTarget futureTarget, Class<?> baseType, Class<?> ... additionalInterfaces) {
        if (baseType != null && !baseType.isInterface() && Modifier.isFinal(baseType.getModifiers())) {
            if (additionalInterfaces.length > 0) {
                return GrapheneProxy.getProxyForFutureTarget(futureTarget, additionalInterfaces[0], additionalInterfaces);
            }
            throw new IllegalStateException("Can't create a proxy for " + baseType + ", it's final and no additional interface has been given.");
        }
        GrapheneProxyHandler handler = GrapheneProxyHandler.forFuture(futureTarget);
        return (T)GrapheneProxy.createProxy(handler, baseType, additionalInterfaces);
    }

    static <T> T createProxy(GrapheneProxyHandler interceptor, Class<T> baseType, Class<?> ... additionalInterfaces) {
        Class<?>[] ancillaryTypes = GrapheneProxyUtil.concatClasses(additionalInterfaces, GrapheneProxyInstance.class);
        if (baseType == null || baseType.isInterface()) {
            if (baseType != null) {
                ancillaryTypes = GrapheneProxyUtil.concatClasses(ancillaryTypes, baseType);
            }
            return (T)Proxy.newProxyInstance(GrapheneProxy.class.getClassLoader(), ancillaryTypes, (InvocationHandler)interceptor);
        }
        return ClassImposterizer.INSTANCE.imposterise(interceptor, baseType, ancillaryTypes);
    }

    public static interface FutureTarget {
        public Object getTarget();
    }
}

