/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.SeleniumResourceProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keyboard;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;

@RunWith(value=MockitoJUnitRunner.class)
public class TestSeleniumResourceProvider {
    @Mock(extraInterfaces={HasInputDevices.class})
    WebDriver driver;

    @Before
    public void setUp() {
        GrapheneContext.set((WebDriver)this.driver);
    }

    @After
    public void tearDown() {
        GrapheneContext.reset();
    }

    @Test
    public void testDirectProviderCanProvideMethod() {
        SeleniumResourceProvider.WebDriverProvider provider = new SeleniumResourceProvider.WebDriverProvider();
        Assert.assertTrue((boolean)provider.canProvide(WebDriver.class));
        Assert.assertFalse((boolean)provider.canProvide(JavascriptExecutor.class));
    }

    @Test
    public void testDirectProviderLookup() {
        SeleniumResourceProvider.WebDriverProvider provider = new SeleniumResourceProvider.WebDriverProvider();
        Object object = provider.lookup(null, null);
        Assert.assertTrue((boolean)(object instanceof WebDriver));
    }

    @Test
    public void testIndirectProviderCanProvideMethod() {
        SeleniumResourceProvider.KeyboardProvider provider = new SeleniumResourceProvider.KeyboardProvider();
        Assert.assertTrue((boolean)provider.canProvide(Keyboard.class));
        Assert.assertFalse((boolean)provider.canProvide(Mouse.class));
    }

    @Test
    public void testIndirectProviderLookup() {
        SeleniumResourceProvider.KeyboardProvider provider = new SeleniumResourceProvider.KeyboardProvider();
        Object object = provider.lookup(null, null);
        Assert.assertTrue((boolean)(object instanceof Keyboard));
    }

    @Test
    public void testMouseProviderLookup() {
        SeleniumResourceProvider.MouseProvider provider = new SeleniumResourceProvider.MouseProvider();
        Object object = provider.lookup(null, null);
        Assert.assertTrue((boolean)(object instanceof Mouse));
    }

    @Test
    public void testActionsProviderLookup() {
        SeleniumResourceProvider.ActionsProvider provider = new SeleniumResourceProvider.ActionsProvider();
        Mouse mouse = (Mouse)Mockito.mock(Mouse.class);
        Keyboard keyboard = (Keyboard)Mockito.mock(Keyboard.class);
        Mockito.when((Object)((HasInputDevices)this.driver).getMouse()).thenReturn((Object)mouse);
        Mockito.when((Object)((HasInputDevices)this.driver).getKeyboard()).thenReturn((Object)keyboard);
        Actions actions = (Actions)provider.lookup(null, null);
        actions.click().perform();
        ((Mouse)Mockito.verify((Object)mouse)).click(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mouse, keyboard});
    }
}

