/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.context;

import org.jboss.arquillian.graphene.enricher.SearchContextInterceptor;
import org.jboss.arquillian.graphene.enricher.StaleElementInterceptor;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyUtil;
import org.openqa.selenium.HasInputDevices;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrapheneContext {
    private static final ThreadLocal<WebDriver> REFERENCE = new ThreadLocal();
    private static final ThreadLocal<GrapheneProxyHandler> HANDLER = new ThreadLocal<GrapheneProxyHandler>(){

        @Override
        protected GrapheneProxyHandler initialValue() {
            return GrapheneProxyHandler.forFuture(TARGET);
        }
    };
    private static GrapheneProxy.FutureTarget TARGET = new GrapheneProxy.FutureTarget(){

        public Object getTarget() {
            return GrapheneContext.get();
        }
    };

    private GrapheneContext() {
    }

    public static void set(WebDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("context instance can't be null");
        }
        if (GrapheneProxy.isProxyInstance(driver)) {
            throw new IllegalArgumentException("instance of the proxy can't be set to the context");
        }
        REFERENCE.set(driver);
    }

    public static void reset() {
        REFERENCE.set(null);
        HANDLER.get().resetInterceptors();
    }

    static WebDriver get() {
        WebDriver driver = REFERENCE.get();
        if (driver == null) {
            throw new NullPointerException("context is null - it needs to be setup before starting to use it");
        }
        return driver;
    }

    public static boolean isInitialized() {
        return REFERENCE.get() != null;
    }

    public static WebDriver getProxy() {
        WebDriver webdriver = (WebDriver)GrapheneProxy.getProxyForHandler(HANDLER.get(), null, WebDriver.class, JavascriptExecutor.class, HasInputDevices.class);
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)webdriver;
        proxy.registerInterceptor(new SearchContextInterceptor());
        proxy.registerInterceptor(new StaleElementInterceptor());
        return webdriver;
    }

    public static WebDriver getAugmentedProxy() {
        WebDriver currentDriver = REFERENCE.get();
        Class<?>[] interfaces = GrapheneProxyUtil.getInterfaces(currentDriver.getClass());
        WebDriver augmentedProxy = (WebDriver)GrapheneContext.getProxyForInterfaces(interfaces);
        return augmentedProxy;
    }

    public static <T extends WebDriver> T getProxyForDriver(Class<T> webDriverImplClass, Class<?> ... additionalInterfaces) {
        WebDriver webdriver = (WebDriver)GrapheneProxy.getProxyForHandler(HANDLER.get(), webDriverImplClass, additionalInterfaces);
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)webdriver;
        proxy.registerInterceptor(new SearchContextInterceptor());
        proxy.registerInterceptor(new StaleElementInterceptor());
        return (T)webdriver;
    }

    public static <T> T getProxyForInterfaces(Class<?> ... interfaces) {
        Class<?>[] interfacesIncludingWebdriver = GrapheneProxyUtil.concatClasses(interfaces, WebDriver.class);
        Object webdriver = GrapheneProxy.getProxyForHandler(HANDLER.get(), null, interfacesIncludingWebdriver);
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)webdriver;
        proxy.registerInterceptor(new SearchContextInterceptor());
        proxy.registerInterceptor(new StaleElementInterceptor());
        return webdriver;
    }

    public static boolean holdsInstanceOf(Class<?> clazz) {
        return clazz.isAssignableFrom(GrapheneContext.get().getClass());
    }
}

