/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.guard;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.context.GrapheneConfigurationContext;
import org.jboss.arquillian.graphene.guard.RequestGuard;
import org.jboss.arquillian.graphene.guard.RequestGuardException;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.page.RequestState;
import org.jboss.arquillian.graphene.page.RequestType;
import org.jboss.arquillian.graphene.page.document.Document;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.proxy.Interceptor;
import org.jboss.arquillian.graphene.proxy.InvocationContext;
import org.jboss.arquillian.graphene.wait.FluentWait;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestGuardFactory {
    private static RequestGuard guard = JSInterfaceFactory.create(RequestGuard.class);
    private static Document document = JSInterfaceFactory.create(Document.class);
    private static DocumentReady documentReady = new DocumentReady();
    private static RequestIsDone requestIsDone = new RequestIsDone();
    private static RequestChange requestChange = new RequestChange();
    private static FluentWait<WebDriver, Void> waitGuard = Graphene.waitAjax().withTimeout(GrapheneConfigurationContext.getProxy().getWaitGuardInterval(), TimeUnit.SECONDS).pollingEvery(Math.min(GrapheneConfigurationContext.getProxy().getWaitGuardInterval() * 100L, 200L), TimeUnit.MILLISECONDS);

    public static <T> T guard(T target, final RequestType requestExpected, final boolean strict) {
        if (requestExpected == null) {
            throw new IllegalArgumentException("The paremeter [requestExpected] is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("The paremeter [target] is null.");
        }
        GrapheneProxyInstance proxy = GrapheneProxy.isProxyInstance(target) ? (GrapheneProxyInstance)((GrapheneProxyInstance)target).copy() : (GrapheneProxyInstance)GrapheneProxy.getProxyForTarget(target);
        proxy.registerInterceptor(new Interceptor(){

            public Object intercept(InvocationContext context) throws Throwable {
                guard.clearRequestDone();
                Object result = context.invoke();
                RequestType requestType = strict ? this.waitForRequestChange() : this.waitForRequestType(requestExpected);
                if (!requestType.equals((Object)requestExpected)) {
                    throw new RequestGuardException(requestExpected, requestType);
                }
                this.waitForRequestFinished();
                return result;
            }

            private RequestType waitForRequestChange() {
                try {
                    return (RequestType)((Object)waitGuard.until(requestChange));
                }
                catch (TimeoutException e) {
                    return RequestType.NONE;
                }
            }

            private RequestType waitForRequestType(RequestType requestType) {
                try {
                    return (RequestType)((Object)waitGuard.until(new RequestTypeDone(requestExpected)));
                }
                catch (TimeoutException e) {
                    return guard.getRequestType();
                }
            }

            private void waitForRequestFinished() {
                switch (requestExpected) {
                    case HTTP: {
                        waitGuard.withMessage("Document didn't become ready").until(documentReady);
                        return;
                    }
                    case XHR: {
                        waitGuard.until(requestIsDone);
                        return;
                    }
                    case NONE: {
                        return;
                    }
                }
            }
        });
        return (T)proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestTypeDone
    implements Function<WebDriver, RequestType> {
        private RequestType requestExpected;

        public RequestTypeDone(RequestType requestExpected) {
            this.requestExpected = requestExpected;
        }

        public RequestType apply(WebDriver driver) {
            RequestType type = guard.getRequestType();
            if (!this.requestExpected.equals((Object)type)) {
                return null;
            }
            return type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestChange
    implements Function<WebDriver, RequestType> {
        private RequestChange() {
        }

        public RequestType apply(WebDriver driver) {
            RequestType type = guard.getRequestType();
            return RequestType.NONE.equals((Object)type) ? null : type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RequestIsDone
    implements Predicate<WebDriver> {
        private RequestIsDone() {
        }

        public boolean apply(WebDriver driver) {
            RequestState state = guard.getRequestState();
            return RequestState.DONE.equals((Object)state);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DocumentReady
    implements Predicate<WebDriver> {
        private DocumentReady() {
        }

        public boolean apply(WebDriver driver) {
            return "complete".equals(document.getReadyState());
        }
    }
}

