/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.TestingDriverStub;
import org.jboss.arquillian.graphene.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.javascript.AbstractJavaScriptTest;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.javascript.TestingEnum;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class TestParameters
extends AbstractJavaScriptTest {
    @Spy
    TestingDriverStub executor = new TestingDriverStub();
    TestingInterface instance;

    @Before
    public void prepareTest() {
        MockitoAnnotations.initMocks((Object)this);
        this.instance = (TestingInterface)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)this.executor, Default.class), TestingInterface.class);
        Mockito.when((Object)this.executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
    }

    @Test
    public void test_stringParameters() {
        this.instance.stringParameters("test");
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "stringParameters"), "test");
    }

    @Test
    public void test_integerParameters() {
        this.instance.integerParameters(2);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "integerParameters"), 2);
    }

    @Test
    public void test_integerObjectParametes() {
        this.instance.integerObjectParameters(2);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "integerObjectParameters"), 2);
    }

    @Test
    public void test_elementParameters() {
        WebElement element = (WebElement)Mockito.mock(WebElement.class);
        this.instance.elementParameters(element);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "elementParameters"), element);
    }

    @Test
    public void test_enumParameters() {
        this.instance.enumParameters(TestingEnum.VALUE2);
        ((TestingDriverStub)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "enumParameters"), "VALUE2");
    }

    @JavaScript(value="base")
    public static interface TestingInterface {
        public void stringParameters(String var1);

        public void integerParameters(int var1);

        public void integerObjectParameters(Integer var1);

        public void elementParameters(WebElement var1);

        public void enumParameters(TestingEnum var1);
    }
}

