/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.findby;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import org.jboss.arquillian.graphene.enricher.findby.FindBy;
import org.jboss.arquillian.graphene.enricher.findby.How;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.findby.FindBys;
import org.jboss.arquillian.graphene.spi.findby.ImplementsLocationStrategy;
import org.jboss.arquillian.graphene.spi.findby.LocationStrategy;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.CacheLookup;
import org.openqa.selenium.support.pagefactory.ByChained;

public class Annotations {
    private final Field field;
    private final How defaultElementLocatingStrategy;

    public Annotations(Field field, How defaultElementLocatingStrategy) {
        this.field = field;
        this.defaultElementLocatingStrategy = defaultElementLocatingStrategy;
    }

    public boolean isLookupCached() {
        return this.field.getAnnotation(CacheLookup.class) != null;
    }

    public By buildBy() {
        this.assertValidAnnotations();
        By by = null;
        by = this.checkAndProcessEmptyFindBy();
        FindBys grapheneFindBys = this.field.getAnnotation(FindBys.class);
        if (by == null && grapheneFindBys != null) {
            by = this.buildByFromGrapheneFindBys(grapheneFindBys);
        }
        org.openqa.selenium.support.FindBys webDriverFindBys = this.field.getAnnotation(org.openqa.selenium.support.FindBys.class);
        if (by == null && webDriverFindBys != null) {
            by = this.buildByFromWebDriverFindBys(webDriverFindBys);
        }
        org.openqa.selenium.support.FindBy findBy = this.field.getAnnotation(org.openqa.selenium.support.FindBy.class);
        if (by == null && findBy != null) {
            by = this.buildByFromFindBy(findBy);
        }
        FindBy grapheneFindBy = this.field.getAnnotation(FindBy.class);
        if (by == null && grapheneFindBy != null) {
            by = this.buildByFromFindBy(grapheneFindBy);
        }
        for (Annotation annotation : this.field.getAnnotations()) {
            ImplementsLocationStrategy strategy = annotation.annotationType().getAnnotation(ImplementsLocationStrategy.class);
            if (strategy == null) continue;
            by = this.buildByFromLocationStrategy(strategy, annotation);
        }
        if (by == null) {
            by = this.buildByFromDefault();
        }
        if (by == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
        }
        return by;
    }

    private By checkAndProcessEmptyFindBy() {
        int numberOfValues;
        FindBy grapheneFindBy;
        int numberOfValues2;
        By result = null;
        org.openqa.selenium.support.FindBy findBy = this.field.getAnnotation(org.openqa.selenium.support.FindBy.class);
        if (findBy != null && (numberOfValues2 = this.assertValidFindBy(findBy)) == 0) {
            result = this.buildByFromDefault();
        }
        if ((grapheneFindBy = this.field.getAnnotation(FindBy.class)) != null && (numberOfValues = this.assertValidFindBy(grapheneFindBy)) == 0) {
            result = this.buildByFromDefault();
        }
        return result;
    }

    protected By buildByFromDefault() {
        String using = this.field.getName();
        return this.getByFromGrapheneHow(this.defaultElementLocatingStrategy, using);
    }

    protected By buildByFromLocationStrategy(ImplementsLocationStrategy strategy, Annotation annotation) {
        try {
            LocationStrategy transformer = (LocationStrategy)strategy.value().newInstance();
            return transformer.fromAnnotation(annotation);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot use locationStrategy " + strategy + " on annotation " + annotation + " on field " + this.field + ": " + e.getMessage(), e);
        }
    }

    protected By buildByFromGrapheneFindBys(FindBys grapheneFindBys) {
        this.assertValidGrapheneFindBys(grapheneFindBys);
        FindBy[] findByArray = grapheneFindBys.value();
        By[] byArray = new By[findByArray.length];
        for (int i = 0; i < findByArray.length; ++i) {
            byArray[i] = this.buildByFromFindBy(findByArray[i]);
        }
        return new ByChained(byArray);
    }

    protected By buildByFromWebDriverFindBys(org.openqa.selenium.support.FindBys webDriverFindBys) {
        this.assertValidWebDriverFindBys(webDriverFindBys);
        org.openqa.selenium.support.FindBy[] findByArray = webDriverFindBys.value();
        By[] byArray = new By[findByArray.length];
        for (int i = 0; i < findByArray.length; ++i) {
            byArray[i] = this.buildByFromFindBy(findByArray[i]);
        }
        return new ByChained(byArray);
    }

    protected By buildByFromFindBy(org.openqa.selenium.support.FindBy findBy) {
        this.assertValidFindBy(findBy);
        By ans = this.buildByFromShortFindBy(findBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(findBy);
        }
        return ans;
    }

    protected By buildByFromFindBy(FindBy findBy) {
        this.assertValidFindBy(findBy);
        By ans = this.buildByFromShortFindBy(findBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(findBy);
        }
        return ans;
    }

    protected By buildByFromLongFindBy(org.openqa.selenium.support.FindBy findBy) {
        org.openqa.selenium.support.How how = findBy.how();
        String using = findBy.using();
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    protected By buildByFromLongFindBy(FindBy findBy) {
        How how = findBy.how();
        String using = findBy.using();
        return this.getByFromGrapheneHow(how, using);
    }

    private By getByFromGrapheneHow(How how, String using) {
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
            case JQUERY: {
                return new ByJQuery(using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    protected By buildByFromShortFindBy(org.openqa.selenium.support.FindBy findBy) {
        if (!"".equals(findBy.className())) {
            return By.className((String)findBy.className());
        }
        if (!"".equals(findBy.css())) {
            return By.cssSelector((String)findBy.css());
        }
        if (!"".equals(findBy.id())) {
            return By.id((String)findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            return By.linkText((String)findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            return By.name((String)findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            return By.partialLinkText((String)findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            return By.tagName((String)findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            return By.xpath((String)findBy.xpath());
        }
        return null;
    }

    protected By buildByFromShortFindBy(FindBy findBy) {
        if (!"".equals(findBy.className())) {
            return By.className((String)findBy.className());
        }
        if (!"".equals(findBy.css())) {
            return By.cssSelector((String)findBy.css());
        }
        if (!"".equals(findBy.id())) {
            return By.id((String)findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            return By.linkText((String)findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            return By.name((String)findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            return By.partialLinkText((String)findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            return By.tagName((String)findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            return By.xpath((String)findBy.xpath());
        }
        if (!"".equals(findBy.jquery())) {
            return new ByJQuery(findBy.jquery());
        }
        return null;
    }

    private void assertValidAnnotations() {
        FindBys grapheneFindBys = this.field.getAnnotation(FindBys.class);
        org.openqa.selenium.support.FindBys webDriverFindBys = this.field.getAnnotation(org.openqa.selenium.support.FindBys.class);
        org.openqa.selenium.support.FindBy webDriverFindBy = this.field.getAnnotation(org.openqa.selenium.support.FindBy.class);
        FindBy grapheneFindBy = this.field.getAnnotation(FindBy.class);
        if (!(grapheneFindBys == null && webDriverFindBys == null || webDriverFindBy == null && grapheneFindBy == null)) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
    }

    private void assertValidGrapheneFindBys(FindBys grapheneFindBys) {
        for (FindBy grapheneFindBy : grapheneFindBys.value()) {
            this.assertValidFindBy(grapheneFindBy);
        }
    }

    private void assertValidWebDriverFindBys(org.openqa.selenium.support.FindBys webDriverFindBys) {
        for (org.openqa.selenium.support.FindBy webDriverFindBy : webDriverFindBys.value()) {
            this.assertValidFindBy(webDriverFindBy);
        }
    }

    private int assertValidFindBy(org.openqa.selenium.support.FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<String> finders = new HashSet<String>();
        if (!"".equals(findBy.using())) {
            finders.add("how: " + findBy.using());
        }
        if (!"".equals(findBy.className())) {
            finders.add("class name:" + findBy.className());
        }
        if (!"".equals(findBy.css())) {
            finders.add("css:" + findBy.css());
        }
        if (!"".equals(findBy.id())) {
            finders.add("id: " + findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            finders.add("link text: " + findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            finders.add("name: " + findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add("partial link text: " + findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            finders.add("tag name: " + findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            finders.add("xpath: " + findBy.xpath());
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
        return finders.size();
    }

    private int assertValidFindBy(FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<String> finders = new HashSet<String>();
        if (!"".equals(findBy.using())) {
            finders.add("how: " + findBy.using());
        }
        if (!"".equals(findBy.className())) {
            finders.add("class name:" + findBy.className());
        }
        if (!"".equals(findBy.css())) {
            finders.add("css:" + findBy.css());
        }
        if (!"".equals(findBy.id())) {
            finders.add("id: " + findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            finders.add("link text: " + findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            finders.add("name: " + findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add("partial link text: " + findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            finders.add("tag name: " + findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            finders.add("xpath: " + findBy.xpath());
        }
        if (!"".equals(findBy.jquery())) {
            finders.add("xpath: " + findBy.jquery());
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
        return finders.size();
    }
}

