/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.findby;

import java.util.List;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.findby.JQuerySearchContext;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByJQueryImpl
extends By {
    private final String selector;

    public ByJQueryImpl(String selector) {
        Validate.notNull((Object)selector, (String)"Cannot find elements when selector is null!");
        this.selector = selector;
    }

    public String toString() {
        return "ByJQuery(\"" + this.selector + "\")";
    }

    public List<WebElement> findElements(SearchContext searchContext) {
        List<WebElement> elements;
        block4: {
            GrapheneContext grapheneContext = this.getGrapheneContext(searchContext);
            JQuerySearchContext jQuerySearchContext = JSInterfaceFactory.create(grapheneContext, JQuerySearchContext.class);
            try {
                if (searchContext instanceof WebElement) {
                    elements = jQuerySearchContext.findElementsInElement(this.selector, (WebElement)searchContext);
                    break block4;
                }
                if (searchContext instanceof WebDriver) {
                    elements = jQuerySearchContext.findElements(this.selector);
                    break block4;
                }
                throw new WebDriverException("Cannot determine the SearchContext you are passing to the findBy/s method! It is not instance of WebDriver nor WebElement! It is: " + searchContext);
            }
            catch (Exception ex) {
                throw new WebDriverException("Can not locate element using selector " + this.selector + " Check out whether it is correct!", (Throwable)ex);
            }
        }
        return elements;
    }

    public WebElement findElement(SearchContext context) {
        List<WebElement> elements = this.findElements(context);
        if (elements == null || elements.isEmpty()) {
            throw new NoSuchElementException("Cannot locate element using: " + this.selector);
        }
        return elements.get(0);
    }

    private GrapheneContext getGrapheneContext(SearchContext searchContext) {
        if (searchContext instanceof GrapheneProxyInstance) {
            return ((GrapheneProxyInstance)searchContext).getContext();
        }
        return GrapheneContext.lastContext();
    }
}

