/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.SeleniumResourceProvider;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.interactions.internal.Coordinates;

@RunWith(value=MockitoJUnitRunner.class)
public class TestSeleniumResourceProvider {
    @Mock(extraInterfaces={HasInputDevices.class})
    WebDriver driver;

    @Before
    public void setUp() {
        Mockito.when((Object)((HasInputDevices)this.driver).getKeyboard()).thenReturn((Object)new Keyboard(){

            public void sendKeys(CharSequence ... keysToSend) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void pressKey(CharSequence keyToPress) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void releaseKey(CharSequence keyToRelease) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        Mockito.when((Object)((HasInputDevices)this.driver).getMouse()).thenReturn((Object)new Mouse(){

            public void click(Coordinates where) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void doubleClick(Coordinates where) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void mouseDown(Coordinates where) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void mouseUp(Coordinates where) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void mouseMove(Coordinates where) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void mouseMove(Coordinates where, long xOffset, long yOffset) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void contextClick(Coordinates where) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)this.driver, Default.class);
    }

    @After
    public void tearDown() {
        GrapheneContext.removeContextFor(Default.class);
    }

    @Test
    public void testDirectProviderCanProvideMethod() {
        SeleniumResourceProvider.WebDriverProvider provider = new SeleniumResourceProvider.WebDriverProvider();
        Assert.assertTrue((boolean)provider.canProvide(WebDriver.class));
        Assert.assertFalse((boolean)provider.canProvide(JavascriptExecutor.class));
    }

    @Test
    public void testDirectProviderLookup() {
        SeleniumResourceProvider.WebDriverProvider provider = new SeleniumResourceProvider.WebDriverProvider();
        Object object = provider.lookup(null, null);
        Assert.assertTrue((boolean)(object instanceof WebDriver));
    }

    @Test
    public void testIndirectProviderCanProvideMethod() {
        SeleniumResourceProvider.KeyboardProvider provider = new SeleniumResourceProvider.KeyboardProvider();
        Assert.assertTrue((boolean)provider.canProvide(Keyboard.class));
        Assert.assertFalse((boolean)provider.canProvide(Mouse.class));
    }

    @Test
    public void testIndirectProviderLookup() {
        SeleniumResourceProvider.KeyboardProvider provider = new SeleniumResourceProvider.KeyboardProvider();
        Object object = provider.lookup(null, null);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Keyboard));
        Assert.assertTrue((boolean)(object instanceof GrapheneProxyInstance));
    }

    @Test
    public void testMouseProviderLookup() {
        SeleniumResourceProvider.MouseProvider provider = new SeleniumResourceProvider.MouseProvider();
        Object object = provider.lookup(null, null);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof Mouse));
        Assert.assertTrue((boolean)(object instanceof GrapheneProxyInstance));
    }

    @Test
    public void testActionsProviderLookup() {
        SeleniumResourceProvider.ActionsProvider provider = new SeleniumResourceProvider.ActionsProvider();
        Mouse mouse = (Mouse)Mockito.mock(Mouse.class);
        Keyboard keyboard = (Keyboard)Mockito.mock(Keyboard.class);
        Mockito.when((Object)((HasInputDevices)this.driver).getMouse()).thenReturn((Object)mouse);
        Mockito.when((Object)((HasInputDevices)this.driver).getKeyboard()).thenReturn((Object)keyboard);
        Actions actions = (Actions)provider.lookup(null, null);
        actions.click().perform();
        ((Mouse)Mockito.verify((Object)mouse)).click(null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mouse, keyboard});
    }
}

