/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.element;

import java.util.logging.Level;
import org.jboss.arquillian.graphene.condition.element.AbstractElementCondition;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractElementBooleanCondition
extends AbstractElementCondition<Boolean> {
    private final boolean negation;

    public AbstractElementBooleanCondition(WebElement element) {
        this(element, false);
    }

    public AbstractElementBooleanCondition(WebElement element, boolean negation) {
        super(element);
        this.negation = negation;
    }

    @Override
    public Boolean apply(WebDriver driver) {
        try {
            if (this.negation) {
                return (Boolean)this.check(driver) == false;
            }
            return (Boolean)this.check(driver);
        }
        catch (StaleElementReferenceException ignored) {
            LOGGER.log(Level.WARNING, "The element is stale.", ignored);
            return null;
        }
    }

    protected boolean getNegation() {
        return this.negation;
    }
}

