/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.jboss.arquillian.graphene.GrapheneElementImpl;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.SearchContextInterceptor;
import org.jboss.arquillian.graphene.enricher.StaleElementInterceptor;
import org.jboss.arquillian.graphene.enricher.WrapsElementInterceptor;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.intercept.InterceptorBuilder;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.ByIdOrName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebElementUtils {
    private static final Logger LOGGER = Logger.getLogger(WebElementUtils.class.getName());
    private static final String EMPTY_FIND_BY_WARNING = " Be aware of the fact that fields anotated with empty @FindBy were located by default strategy, which is ByIdOrName with field name as locator! ";
    private static final Class<?>[] INTERFACES_PROXY_SHOULD_IMPLEMENT = new Class[]{Locatable.class, WrapsElement.class, FindsByClassName.class, FindsByCssSelector.class, FindsById.class, FindsByLinkText.class, FindsByName.class, FindsByTagName.class, FindsByXPath.class, GrapheneElement.class};

    private WebElementUtils() {
    }

    public static WebElement findElement(GrapheneContext context, final By by, final GrapheneProxy.FutureTarget searchContextFuture) {
        WebElementUtils.dropProxyAndFindElement(by, (SearchContext)searchContextFuture.getTarget());
        return WebElementUtils.findElement(context, new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                return WebElementUtils.dropProxyAndFindElement(by, (SearchContext)searchContextFuture.getTarget());
            }
        });
    }

    public static List<WebElement> findElementsLazily(final GrapheneContext context, final By by, final GrapheneProxy.FutureTarget searchContextFuture) {
        List elements = (List)GrapheneProxy.getProxyForHandler(GrapheneContextualHandler.forFuture(context, new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                ArrayList<WebElement> result = new ArrayList<WebElement>();
                List<WebElement> elements = WebElementUtils.dropProxyAndFindElements(by, (SearchContext)searchContextFuture.getTarget());
                if (by instanceof ByIdOrName && elements.isEmpty()) {
                    LOGGER.log(Level.WARNING, WebElementUtils.EMPTY_FIND_BY_WARNING);
                }
                for (int i = 0; i < elements.size(); ++i) {
                    result.add(WebElementUtils.findElementLazily(context, by, searchContextFuture, i));
                }
                return result;
            }
        }), List.class, new Class[0]);
        GrapheneProxyInstance proxy = (GrapheneProxyInstance)((Object)elements);
        proxy.registerInterceptor(new StaleElementInterceptor());
        return elements;
    }

    public static WebElement findElementLazily(GrapheneContext context, final By by, final GrapheneProxy.FutureTarget searchContextFuture, final int indexInList) {
        return WebElementUtils.findElement(context, new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                return WebElementUtils.dropProxyAndFindElements(by, (SearchContext)searchContextFuture.getTarget()).get(indexInList);
            }
        });
    }

    public static WebElement findElementLazily(final By by, final SearchContext searchContext, final int indexInList) {
        return WebElementUtils.findElement(WebElementUtils.getContext(searchContext), new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                return WebElementUtils.dropProxyAndFindElements(by, searchContext).get(indexInList);
            }
        });
    }

    public static WebElement findElementLazily(final By by, final SearchContext searchContext) {
        return WebElementUtils.findElement(WebElementUtils.getContext(searchContext), new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                try {
                    return WebElementUtils.dropProxyAndFindElement(by, searchContext);
                }
                catch (NoSuchElementException ex) {
                    throw new NoSuchElementException((by instanceof ByIdOrName ? WebElementUtils.EMPTY_FIND_BY_WARNING : "") + ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    public static List<WebElement> findElementsLazily(By by, final SearchContext searchContext) {
        return WebElementUtils.findElementsLazily(WebElementUtils.getContext(searchContext), by, new GrapheneProxy.FutureTarget(){

            public Object getTarget() {
                return searchContext;
            }
        });
    }

    protected static WebElement findElement(GrapheneContext context, GrapheneProxy.FutureTarget target) {
        WebElement element = (WebElement)GrapheneProxy.getProxyForFutureTarget(context, target, WebElement.class, INTERFACES_PROXY_SHOULD_IMPLEMENT);
        GrapheneProxyInstance elementProxy = (GrapheneProxyInstance)element;
        InterceptorBuilder b = new InterceptorBuilder();
        b.interceptInvocation(WrapsElement.class, new WrapsElementInterceptor(elementProxy)).getWrappedElement();
        elementProxy.registerInterceptor(b.build());
        elementProxy.registerInterceptor(new StaleElementInterceptor());
        elementProxy.registerInterceptor(new SearchContextInterceptor());
        return element;
    }

    protected static WebElement dropProxyAndFindElement(By by, SearchContext searchContext) {
        WebElement result;
        if (searchContext instanceof GrapheneProxyInstance) {
            SearchContext unwrapped = (SearchContext)((GrapheneProxyInstance)searchContext).unwrap();
            result = unwrapped.findElement(by);
        } else {
            result = searchContext.findElement(by);
        }
        return new GrapheneElementImpl(result);
    }

    protected static List<WebElement> dropProxyAndFindElements(By by, SearchContext searchContext) {
        List webElements = searchContext instanceof GrapheneProxyInstance ? (by instanceof ByJQuery ? by.findElements(searchContext) : ((SearchContext)((GrapheneProxyInstance)searchContext).unwrap()).findElements(by)) : searchContext.findElements(by);
        ArrayList<WebElement> result = new ArrayList<WebElement>(webElements.size());
        for (WebElement webElement : webElements) {
            result.add((WebElement)new GrapheneElementImpl(webElement));
        }
        return result;
    }

    protected static GrapheneContext getContext(Object object) {
        if (!GrapheneProxy.isProxyInstance(object)) {
            throw new IllegalArgumentException("The parameter [object] has to be instance of " + GrapheneProxyInstance.class.getName() + ", but it is not. The given object is " + object + ".");
        }
        return ((GrapheneProxyInstance)object).getGrapheneContext();
    }
}

