/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.condition.element;

import org.jboss.arquillian.graphene.condition.AbstractBooleanConditionFactory;
import org.jboss.arquillian.graphene.condition.AttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.BooleanConditionWrapper;
import org.jboss.arquillian.graphene.condition.ElementConditionFactory;
import org.jboss.arquillian.graphene.condition.StringConditionFactory;
import org.jboss.arquillian.graphene.condition.attribute.ElementAttributeConditionFactory;
import org.jboss.arquillian.graphene.condition.element.ElementIsEnabled;
import org.jboss.arquillian.graphene.condition.element.ElementIsPresent;
import org.jboss.arquillian.graphene.condition.element.WebElementTextConditionFactory;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

public class WebElementConditionFactory
extends AbstractBooleanConditionFactory<ElementConditionFactory>
implements ElementConditionFactory {
    private WebElement element;

    public WebElementConditionFactory(WebElement element) {
        if (element == null) {
            throw new IllegalArgumentException("The element can't be null.");
        }
        this.element = element;
    }

    @Override
    public AttributeConditionFactory attribute(String attribute) {
        return new ElementAttributeConditionFactory(this.element, attribute);
    }

    @Override
    public ExpectedCondition<Boolean> isPresent() {
        return new ElementIsPresent(this.element, this.getNegation());
    }

    @Override
    public ExpectedCondition<Boolean> isSelected() {
        return ExpectedConditions.elementSelectionStateToBe((WebElement)this.element, (!this.getNegation() ? 1 : 0) != 0);
    }

    @Override
    public ExpectedCondition<Boolean> isVisible() {
        return new BooleanConditionWrapper(ExpectedConditions.visibilityOf((WebElement)this.element), this.getNegation(), NoSuchElementException.class);
    }

    @Override
    public ExpectedCondition<Boolean> isClickable() {
        return new BooleanConditionWrapper(ExpectedConditions.elementToBeClickable((WebElement)this.element), this.getNegation(), NoSuchElementException.class);
    }

    public StringConditionFactory text() {
        return new WebElementTextConditionFactory(this.element, this.getNegation());
    }

    @Override
    protected WebElementConditionFactory copy() {
        WebElementConditionFactory copy = new WebElementConditionFactory(this.element);
        copy.setNegation(this.getNegation());
        return copy;
    }

    @Override
    public ExpectedCondition<Boolean> isEnabled() {
        return new ElementIsEnabled(this.element, this.getNegation());
    }
}

