/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.graphene.TestingDriver;
import org.jboss.arquillian.graphene.enricher.AbstractGrapheneEnricherTest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.By;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

@RunWith(value=MockitoJUnitRunner.class)
public class TestWebElementStaleness
extends AbstractGrapheneEnricherTest {
    private Map<WebElement, Boolean> staleness = new HashMap<WebElement, Boolean>();
    private WebElement rootElement;
    private WebElement webElement;
    private Page page;

    @Before
    public void prepare() {
        this.rootElement = (WebElement)Mockito.mock(WebElement.class, (Answer)new StaleElementAnswer());
        this.webElement = (WebElement)Mockito.mock(WebElement.class, (Answer)new StaleElementAnswer());
        Mockito.when((Object)this.browser.findElement((By)Matchers.any(By.class))).thenReturn((Object)this.rootElement);
        Mockito.when((Object)this.rootElement.findElement((By)Matchers.any(By.class))).thenReturn((Object)this.webElement);
        this.page = new Page();
        this.getGrapheneEnricher().enrich((Object)this.page);
    }

    @Test
    public void test_fragment_subelement_is_stale() {
        this.makeStale(this.webElement);
        this.page.getFragment().getElement().click();
        ((TestingDriver)Mockito.verify((Object)this.browser, (VerificationMode)Mockito.times((int)2))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)this.rootElement, (VerificationMode)Mockito.times((int)2))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)this.webElement, (VerificationMode)Mockito.times((int)2))).click();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.browser, this.webElement});
    }

    @Test
    public void test_page_where_page_fragment_reference_is_stale() {
        this.makeStale(this.rootElement);
        this.makeStale(this.webElement);
        this.page.getFragment().getElement().click();
        ((TestingDriver)Mockito.verify((Object)this.browser, (VerificationMode)Mockito.times((int)2))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)this.rootElement, (VerificationMode)Mockito.times((int)2))).findElement((By)Matchers.any(By.class));
        ((WebElement)Mockito.verify((Object)this.webElement, (VerificationMode)Mockito.times((int)2))).click();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.browser, this.webElement});
    }

    private boolean isStale(WebElement element) {
        Boolean stale = this.staleness.get(element);
        stale = stale == null ? false : stale;
        if (stale.booleanValue()) {
            this.staleness.put(element, false);
        }
        return stale;
    }

    private void makeStale(WebElement element) {
        this.staleness.put(element, true);
    }

    public class StaleElementAnswer
    implements Answer<Object> {
        public Object answer(InvocationOnMock invocation) throws Throwable {
            if (TestWebElementStaleness.this.isStale((WebElement)invocation.getMock())) {
                throw new StaleElementReferenceException("");
            }
            return Answers.RETURNS_SMART_NULLS.get().answer(invocation);
        }
    }

    public static class PageFragment {
        @FindBy(id="test")
        private WebElement element;

        public WebElement getElement() {
            return this.element;
        }
    }

    private static class Page {
        @FindBy(id="test")
        private PageFragment fragment;

        private Page() {
        }

        public PageFragment getFragment() {
            return this.fragment;
        }
    }
}

