/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene;

import java.util.LinkedList;
import java.util.List;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.GrapheneElement;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;

public class GrapheneElementImpl
implements GrapheneElement {
    private final WebElement element;

    public GrapheneElementImpl(WebElement element) {
        this.element = element;
    }

    public boolean isPresent() {
        try {
            this.element.isDisplayed();
            return true;
        }
        catch (NoSuchElementException ignored) {
            return false;
        }
    }

    public List<GrapheneElement> findGrapheneElements(By by) {
        LinkedList<GrapheneElement> grapheneElements = new LinkedList<GrapheneElement>();
        for (WebElement e : this.element.findElements(by)) {
            grapheneElements.add(new GrapheneElementImpl(e));
        }
        return grapheneElements;
    }

    public void click() {
        this.element.click();
    }

    public void submit() {
        this.element.submit();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.element.sendKeys(keysToSend);
    }

    public void clear() {
        this.element.clear();
    }

    public String getTagName() {
        return this.element.getTagName();
    }

    public String getAttribute(String name) {
        return this.element.getAttribute(name);
    }

    public boolean isSelected() {
        return this.element.isSelected();
    }

    public boolean isEnabled() {
        return this.element.isEnabled();
    }

    public String getText() {
        return this.element.getText();
    }

    public List<WebElement> findElements(By by) {
        return this.element.findElements(by);
    }

    public GrapheneElementImpl findElement(By by) {
        return new GrapheneElementImpl(this.element.findElement(by));
    }

    public boolean isDisplayed() {
        return this.element.isDisplayed();
    }

    public Point getLocation() {
        return this.element.getLocation();
    }

    public Dimension getSize() {
        return this.element.getSize();
    }

    public Rectangle getRect() {
        return this.element.getRect();
    }

    public String getCssValue(String propertyName) {
        return this.element.getCssValue(propertyName);
    }

    public WebElement getWrappedElement() {
        return this.element;
    }

    public Coordinates getCoordinates() {
        return ((Locatable)this.element).getCoordinates();
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        return (X)this.element.getScreenshotAs(outputType);
    }

    public int hashCode() {
        if (this.element == null) {
            return super.hashCode();
        }
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (this.element == null) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        return this.element.equals(obj);
    }

    public String toString() {
        return "GrapheneElement -> " + this.element;
    }

    public void doubleClick() {
        Graphene.doubleClick((WebElement)this.element);
    }

    public void writeIntoElement(String text) {
        Graphene.writeIntoElement((WebElement)this.element, (String)text);
    }
}

