/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.elements;

import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.elements.GrapheneSelect;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ISelect;
import org.openqa.selenium.support.ui.Quotes;
import org.openqa.selenium.support.ui.UnexpectedTagNameException;

public class GrapheneSelectImpl
implements GrapheneSelect {
    private final WebElement element;
    private boolean isMulti = false;

    public GrapheneSelectImpl(WebElement element) {
        this.element = element;
    }

    public void setIsMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    public WebElement getWrappedElement() {
        this.checkSelect();
        return this.element;
    }

    public boolean isMultiple() {
        return this.isMulti;
    }

    public List<WebElement> getOptions() {
        return this.getWrappedElement().findElements(By.tagName((String)"option"));
    }

    public List<WebElement> getAllSelectedOptions() {
        return this.getOptions().stream().filter(WebElement::isSelected).collect(Collectors.toList());
    }

    public WebElement getFirstSelectedOption() {
        return this.getOptions().stream().filter(WebElement::isSelected).findFirst().orElseThrow(() -> new NoSuchElementException("No options are selected"));
    }

    public void selectByVisibleText(String text) {
        boolean matched;
        List options = this.getWrappedElement().findElements(By.xpath((String)(".//option[normalize-space(.) = " + Quotes.escape((String)text) + "]")));
        for (WebElement option : options) {
            this.setSelected(option, true);
            if (this.isMultiple()) continue;
            return;
        }
        boolean bl = matched = !options.isEmpty();
        if (!matched && text.contains(" ")) {
            String subStringWithoutSpace = this.getLongestSubstringWithoutSpace(text);
            List candidates = "".equals(subStringWithoutSpace) ? this.getWrappedElement().findElements(By.tagName((String)"option")) : this.getWrappedElement().findElements(By.xpath((String)(".//option[contains(., " + Quotes.escape((String)subStringWithoutSpace) + ")]")));
            String trimmed = text.trim();
            for (WebElement option : candidates) {
                if (!trimmed.equals(option.getText().trim())) continue;
                this.setSelected(option, true);
                if (!this.isMultiple()) {
                    return;
                }
                matched = true;
            }
        }
        if (!matched) {
            throw new NoSuchElementException("Cannot locate option with text: " + text);
        }
    }

    private String getLongestSubstringWithoutSpace(String s) {
        String result = "";
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.length() <= result.length()) continue;
            result = t;
        }
        return result;
    }

    public void selectByIndex(int index) {
        this.setSelectedByIndex(index, true);
    }

    public void selectByValue(String value) {
        for (WebElement option : this.findOptionsByValue(value)) {
            this.setSelected(option, true);
            if (this.isMultiple()) continue;
            return;
        }
    }

    public void deselectAll() {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect all options of a multi-select");
        }
        for (WebElement option : this.getOptions()) {
            this.setSelected(option, false);
        }
    }

    public void deselectByValue(String value) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect options of a multi-select");
        }
        for (WebElement option : this.findOptionsByValue(value)) {
            this.setSelected(option, false);
        }
    }

    public void deselectByIndex(int index) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect options of a multi-select");
        }
        this.setSelectedByIndex(index, false);
    }

    public void deselectByVisibleText(String text) {
        if (!this.isMultiple()) {
            throw new UnsupportedOperationException("You may only deselect options of a multi-select");
        }
        List options = this.getWrappedElement().findElements(By.xpath((String)(".//option[normalize-space(.) = " + Quotes.escape((String)text) + "]")));
        if (options.isEmpty()) {
            throw new NoSuchElementException("Cannot locate option with text: " + text);
        }
        for (WebElement option : options) {
            this.setSelected(option, false);
        }
    }

    private List<WebElement> findOptionsByValue(String value) {
        List options = this.getWrappedElement().findElements(By.xpath((String)(".//option[@value = " + Quotes.escape((String)value) + "]")));
        if (options.isEmpty()) {
            throw new NoSuchElementException("Cannot locate option with value: " + value);
        }
        return options;
    }

    private void setSelectedByIndex(int index, boolean select) {
        String match = String.valueOf(index);
        for (WebElement option : this.getOptions()) {
            if (!match.equals(option.getAttribute("index"))) continue;
            this.setSelected(option, select);
            return;
        }
        throw new NoSuchElementException("Cannot locate option with index: " + index);
    }

    private void setSelected(WebElement option, boolean select) {
        if (option.isSelected() != select) {
            option.click();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ISelect)) {
            return false;
        }
        GrapheneSelect select = (GrapheneSelect)o;
        return Objects.equals(this.element, select.getWrappedElement());
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    private void checkSelect() {
        String tagName = this.element.getTagName();
        if (!"select".equalsIgnoreCase(tagName)) {
            throw new UnexpectedTagNameException("select", tagName);
        }
    }
}

