/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.config.descriptor.api.ExtensionDef;
import org.jboss.arquillian.graphene.configuration.GrapheneConfigurator;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfigured;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneUnconfigured;
import org.jboss.arquillian.test.spi.annotation.SuiteScoped;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConfigurationContextTestCase
extends AbstractTestTestBase {
    @Mock
    private ArquillianDescriptor descriptor;
    @Mock
    private ExtensionDef extensionDefinition;

    @Before
    public void prepareDescriptor() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("waitGuiInterval", "5");
        properties.put("waitAjaxInterval", "25");
        properties.put("waitModelInterval", "125");
        Mockito.when((Object)this.extensionDefinition.getExtensionName()).thenReturn((Object)"graphene");
        Mockito.when((Object)this.extensionDefinition.getExtensionProperties()).thenReturn(properties);
        Mockito.when((Object)this.descriptor.getExtensions()).thenReturn(Arrays.asList(this.extensionDefinition));
    }

    @Test
    public void testConfigurationViaDescriptor() {
        this.getManager().bind(SuiteScoped.class, ArquillianDescriptor.class, (Object)this.descriptor);
        this.fire(new BeforeClass(Object.class));
        this.assertEventFired(GrapheneConfigured.class);
        GrapheneConfiguration configuration = (GrapheneConfiguration)this.getManager().resolve(GrapheneConfiguration.class);
        Assert.assertNotNull((String)"Configuration instance has to be available.", (Object)configuration);
        configuration.validate();
        Assert.assertEquals((String)"'waitGuiInterval' should be 5", (long)5L, (long)configuration.getWaitGuiInterval());
        Assert.assertEquals((String)"'waitAjaxInterval' should be 25", (long)25L, (long)configuration.getWaitAjaxInterval());
        Assert.assertEquals((String)"'waitModelInterval' should be 125", (long)125L, (long)configuration.getWaitModelInterval());
        this.fire(new AfterClass(Object.class));
        this.assertEventFired(GrapheneUnconfigured.class);
    }

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(GrapheneConfigurator.class);
    }
}

