/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.reflect.Field;
import java.util.Arrays;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.DefaultGrapheneRuntime;
import org.jboss.arquillian.graphene.GrapheneRuntime;
import org.jboss.arquillian.graphene.TestingDriver;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.GrapheneEnricher;
import org.jboss.arquillian.graphene.enricher.PageFragmentEnricher;
import org.jboss.arquillian.graphene.enricher.PageObjectEnricher;
import org.jboss.arquillian.graphene.enricher.WebElementEnricher;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.jboss.arquillian.graphene.spi.enricher.SearchContextTestEnricher;
import org.jboss.arquillian.test.spi.TestEnricher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.openqa.selenium.WebDriver;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public abstract class AbstractGrapheneEnricherTest {
    @Mock
    private Instance<ServiceLoader> serviceLoaderInstance;
    @Mock
    protected TestingDriver browser;
    @Mock
    private ServiceLoader serviceLoader;
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private TestEnricher grapheneEnricher;
    private SearchContextTestEnricher webElementEnricher;
    private SearchContextTestEnricher pageObjectEnricher;
    private SearchContextTestEnricher pageFragmentEnricher;

    @Before
    public void prepareServiceLoader() throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        this.grapheneEnricher = new GrapheneEnricher();
        Instance configuration = new Instance(){

            public Object get() {
                return new GrapheneConfiguration();
            }
        };
        this.webElementEnricher = new WebElementEnricher(configuration);
        this.pageObjectEnricher = new PageObjectEnricher();
        this.pageFragmentEnricher = new PageFragmentEnricher(configuration);
        Mockito.when((Object)((ServiceLoader)this.serviceLoaderInstance.get())).thenReturn((Object)this.serviceLoader);
        Mockito.when((Object)this.serviceLoader.all(TestEnricher.class)).thenReturn(Arrays.asList(this.grapheneEnricher));
        Mockito.when((Object)this.serviceLoader.all(SearchContextTestEnricher.class)).thenReturn(Arrays.asList(this.webElementEnricher, this.pageObjectEnricher, this.pageFragmentEnricher));
        for (Object o : Arrays.asList(this.grapheneEnricher, this.webElementEnricher, this.pageObjectEnricher, this.pageFragmentEnricher)) {
            Field serviceLoaderField = o instanceof SearchContextTestEnricher ? AbstractSearchContextEnricher.class.getDeclaredField("serviceLoader") : o.getClass().getDeclaredField("serviceLoader");
            if (!serviceLoaderField.isAccessible()) {
                serviceLoaderField.setAccessible(true);
            }
            serviceLoaderField.set(o, this.serviceLoaderInstance);
        }
        GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)this.browser, Default.class);
        GrapheneRuntime.pushInstance((GrapheneRuntime)new DefaultGrapheneRuntime());
    }

    @After
    public void tearDown() {
        GrapheneRuntime.popInstance();
        GrapheneContext.removeContextFor(Default.class);
    }

    protected final TestEnricher getGrapheneEnricher() {
        return this.grapheneEnricher;
    }

    protected final SearchContextTestEnricher getPageFragmentEnricher() {
        return this.pageFragmentEnricher;
    }

    protected final SearchContextTestEnricher getPageObjectEnricher() {
        return this.pageObjectEnricher;
    }

    protected final SearchContextTestEnricher getWebElementEnricher() {
        return this.webElementEnricher;
    }

    protected final Instance<ServiceLoader> getServiceLoader() {
        return this.serviceLoaderInstance;
    }
}

