/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import org.jboss.arquillian.graphene.TestingDriver;
import org.jboss.arquillian.graphene.enricher.AbstractGrapheneEnricherTest;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;

public class TestWebElementLazyEvaluation
extends AbstractGrapheneEnricherTest {
    @Test
    public void when_WebElement_is_injected_then_it_is_first_evaluated_at_first_interaction() {
        WebElement element = (WebElement)Mockito.mock(WebElement.class);
        Mockito.when((Object)this.browser.findElement((By)ArgumentMatchers.any(By.class))).thenReturn((Object)element);
        TPageFragment fragment = new TPageFragment();
        this.getGrapheneEnricher().enrich((Object)fragment);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.browser, element});
        fragment.getElement().click();
        fragment.getElement().click();
        ((TestingDriver)Mockito.verify((Object)this.browser, (VerificationMode)Mockito.times((int)2))).findElement((By)ArgumentMatchers.any(By.class));
        ((WebElement)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)2))).click();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.browser, element});
    }

    @Test
    public void when_page_fragment_is_injected_then_searching_for_its_siblings_is_done_for_each_invocation() {
        WebElement rootElement = (WebElement)Mockito.mock(WebElement.class);
        WebElement element = (WebElement)Mockito.mock(WebElement.class);
        Mockito.when((Object)this.browser.findElement((By)ArgumentMatchers.any(By.class))).thenReturn((Object)rootElement);
        Mockito.when((Object)rootElement.findElement((By)ArgumentMatchers.any(By.class))).thenReturn((Object)element);
        TPage page = new TPage();
        this.getGrapheneEnricher().enrich((Object)page);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.browser, element});
        page.getFragment().getElement().click();
        page.getFragment().getElement().click();
        page.getFragment().getElement().click();
        ((TestingDriver)Mockito.verify((Object)this.browser, (VerificationMode)Mockito.times((int)3))).findElement((By)ArgumentMatchers.any(By.class));
        ((WebElement)Mockito.verify((Object)rootElement, (VerificationMode)Mockito.times((int)3))).findElement((By)ArgumentMatchers.any(By.class));
        ((WebElement)Mockito.verify((Object)element, (VerificationMode)Mockito.times((int)3))).click();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.browser, element});
    }

    public static class TPageFragment {
        @FindBy(id="test")
        WebElement element;

        public WebElement getElement() {
            return this.element;
        }
    }

    public static class TPage {
        @FindBy(id="test")
        TPageFragment fragment;

        public TPageFragment getFragment() {
            return this.fragment;
        }
    }
}

