/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.TestingDriverStub;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.javascript.AbstractJavaScriptTest;
import org.jboss.arquillian.graphene.javascript.JSInterfaceFactory;
import org.jboss.arquillian.graphene.javascript.JavaScript;
import org.jboss.arquillian.graphene.javascript.MethodName;
import org.jboss.arquillian.graphene.spi.configuration.GrapheneConfiguration;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.openqa.selenium.WebDriver;

public class TestExecution
extends AbstractJavaScriptTest {
    @Test
    public void test_execution() {
        TestingDriverStub executor = (TestingDriverStub)Mockito.spy((Object)new TestingDriverStub());
        Mockito.when((Object)executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
        TestingInterface instance = (TestingInterface)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)executor, Default.class), TestingInterface.class);
        instance.method();
        ((TestingDriverStub)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("TestingInterface", "method"), new Object[0]);
    }

    @Test
    public void test_execution_with_named_method() {
        TestingDriverStub executor = (TestingDriverStub)Mockito.spy((Object)new TestingDriverStub());
        Mockito.when((Object)executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
        TestingInterface instance = (TestingInterface)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)executor, Default.class), TestingInterface.class);
        instance.namedMethod();
        ((TestingDriverStub)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("TestingInterface", "anotherMethodName"), new Object[0]);
    }

    @Test
    public void test_execution_with_base() {
        TestingDriverStub executor = (TestingDriverStub)Mockito.spy((Object)new TestingDriverStub());
        Mockito.when((Object)executor.executeScript("return true;", new Object[0])).thenReturn((Object)true);
        TestingInterfaceWithBase instance = (TestingInterfaceWithBase)JSInterfaceFactory.create((GrapheneContext)GrapheneContext.setContextFor((GrapheneConfiguration)new GrapheneConfiguration(), (WebDriver)executor, Default.class), TestingInterfaceWithBase.class);
        instance.method();
        ((TestingDriverStub)Mockito.verify((Object)executor, (VerificationMode)Mockito.times((int)1))).executeScript(this.invocation("base", "method"), new Object[0]);
    }

    @JavaScript
    public static interface TestingInterface {
        public void method();

        @MethodName(value="anotherMethodName")
        public void namedMethod();
    }

    @JavaScript(value="base")
    public static interface TestingInterfaceWithBase {
        public void method();
    }
}

