/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.page.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.graphene.page.extension.AbstractPageExtensionInstallatorProvider;
import org.jboss.arquillian.graphene.page.extension.PageExtensionInstallator;
import org.jboss.arquillian.graphene.page.extension.PageExtensionRegistry;
import org.jboss.arquillian.graphene.spi.javascript.JavaScript;
import org.jboss.arquillian.graphene.spi.page.PageExtension;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AbstractPageExtensionInstallatorProviderTestCase {
    @Mock
    private PageExtensionRegistry registry;

    @Before
    public void prepareRegistry() {
        Mockito.when((Object)this.registry.getExtension(WithCycleA.class.getName())).thenReturn((Object)new WithCycleA());
        Mockito.when((Object)this.registry.getExtension(WithCycleB.class.getName())).thenReturn((Object)new WithCycleB());
        Mockito.when((Object)this.registry.getExtension(WithoutCycleA.class.getName())).thenReturn((Object)new WithoutCycleA());
        Mockito.when((Object)this.registry.getExtension(WithoutCycleB.class.getName())).thenReturn((Object)new WithoutCycleB());
    }

    @Test(expected=IllegalStateException.class)
    public void testCycleInRequirements() {
        TestedPageExtensionInstallatorProvider provider = new TestedPageExtensionInstallatorProvider(this.registry);
        provider.installator(WithCycleA.class.getName());
    }

    @Test
    public void testNoCycleInRequirements() {
    }

    private static class WithCycleA
    implements PageExtension {
        private WithCycleA() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"");
        }

        public Collection<String> getRequired() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(WithCycleB.class.getName());
            return result;
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"");
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static class WithCycleB
    implements PageExtension {
        private WithCycleB() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"");
        }

        public Collection<String> getRequired() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(WithCycleA.class.getName());
            return result;
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"");
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static class WithoutCycleA
    implements PageExtension {
        private WithoutCycleA() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"");
        }

        public Collection<String> getRequired() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(WithoutCycleB.class.getName());
            return result;
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"");
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static class WithoutCycleB
    implements PageExtension {
        private WithoutCycleB() {
        }

        public JavaScript getExtensionScript() {
            return JavaScript.fromString((String)"");
        }

        public Collection<String> getRequired() {
            return Collections.EMPTY_LIST;
        }

        public JavaScript getInstallationDetectionScript() {
            return JavaScript.fromString((String)"");
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    private static class TestedPageExtensionInstallatorProvider
    extends AbstractPageExtensionInstallatorProvider {
        TestedPageExtensionInstallatorProvider(PageExtensionRegistry registry) {
            super(registry);
        }

        public PageExtensionInstallator createInstallator(PageExtension extension) {
            return null;
        }
    }
}

