/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.proxy;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.drone.api.annotation.Default;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.logging.Logs;

public class TestGrapheneContextualHandler {
    private GrapheneContextualHandler handler;

    @Before
    public void prepare() {
        this.handler = GrapheneContextualHandler.forTarget((GrapheneContext)GrapheneContext.getContextFor(Default.class), null);
    }

    @Test
    public void test_webDriver_methods_which_should_not_return_proxy() {
        IsNotProxyable isNotProxyable = new IsNotProxyable();
        WebDriver driver = (WebDriver)Mockito.mock(WebDriver.class, (Answer)isNotProxyable);
        WebDriver.Options options = (WebDriver.Options)Mockito.mock(WebDriver.Options.class, (Answer)isNotProxyable);
        WebDriver.Navigation navigation = (WebDriver.Navigation)Mockito.mock(WebDriver.Navigation.class, (Answer)isNotProxyable);
        Logs logs = (Logs)Mockito.mock(Logs.class, (Answer)isNotProxyable);
        try {
            driver.toString();
            driver.close();
            driver.equals(new Object());
            driver.get("");
            driver.getClass();
            driver.getCurrentUrl();
            driver.getPageSource();
            driver.getTitle();
            driver.getWindowHandle();
            driver.hashCode();
            driver.quit();
            driver.toString();
            options.addCookie((Cookie)Mockito.mock(Cookie.class));
            options.deleteAllCookies();
            options.deleteCookie((Cookie)Mockito.mock(Cookie.class));
            options.deleteCookieNamed("");
            options.getCookieNamed("");
            navigation.back();
            navigation.forward();
            navigation.to("");
            navigation.to(new URL("http://localhost/"));
            logs.get("");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals(Arrays.asList(new Object[0]), isNotProxyable.getViolations());
    }

    @Test
    public void test_webDriver_methods_which_should_return_proxy() {
        IsProxyable isProxyable = new IsProxyable();
        WebDriver driver = (WebDriver)Mockito.mock(WebDriver.class, (Answer)isProxyable);
        WebDriver.Options options = (WebDriver.Options)Mockito.mock(WebDriver.Options.class, (Answer)isProxyable);
        WebDriver.TargetLocator targetLocator = (WebDriver.TargetLocator)Mockito.mock(WebDriver.TargetLocator.class, (Answer)isProxyable);
        WebDriver.Timeouts timeouts = (WebDriver.Timeouts)Mockito.mock(WebDriver.Timeouts.class, (Answer)isProxyable);
        try {
            driver.manage();
            driver.navigate();
            driver.switchTo();
            driver.findElement(By.className((String)""));
            driver.findElements(By.className((String)""));
            driver.getWindowHandles();
            options.logs();
            options.timeouts();
            options.window();
            options.getCookies();
            targetLocator.activeElement();
            targetLocator.alert();
            targetLocator.defaultContent();
            targetLocator.frame(0);
            targetLocator.frame("name");
            targetLocator.frame((WebElement)Mockito.mock(WebElement.class));
            targetLocator.window("name");
            timeouts.implicitlyWait(1L, TimeUnit.MICROSECONDS);
            timeouts.setScriptTimeout(1L, TimeUnit.MICROSECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals(Arrays.asList(new Object[0]), isProxyable.getViolations());
    }

    private class IsNotProxyable
    implements Answer<Object> {
        List<Method> violations = new LinkedList<Method>();

        private IsNotProxyable() {
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (TestGrapheneContextualHandler.this.handler.isProxyable(method, invocation.getArguments())) {
                this.violations.add(method);
            }
            return null;
        }

        public List<Method> getViolations() {
            return Collections.unmodifiableList(this.violations);
        }
    }

    private class IsProxyable
    implements Answer<Object> {
        List<Method> violations = new LinkedList<Method>();

        private IsProxyable() {
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Method method = invocation.getMethod();
            if (!TestGrapheneContextualHandler.this.handler.isProxyable(method, invocation.getArguments())) {
                this.violations.add(method);
            }
            return null;
        }

        public List<Method> getViolations() {
            return Collections.unmodifiableList(this.violations);
        }
    }
}

