/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.enricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.LinkedList;
import org.jboss.arquillian.graphene.context.GrapheneContext;
import org.jboss.arquillian.graphene.enricher.AbstractSearchContextEnricher;
import org.jboss.arquillian.graphene.enricher.ReflectionHelper;
import org.jboss.arquillian.graphene.enricher.exception.PageObjectInitializationException;
import org.jboss.arquillian.graphene.page.Page;
import org.jboss.arquillian.graphene.proxy.GrapheneContextualHandler;
import org.jboss.arquillian.graphene.proxy.GrapheneProxy;
import org.jboss.arquillian.graphene.proxy.GrapheneProxyInstance;
import org.openqa.selenium.SearchContext;

public class PageObjectEnricher
extends AbstractSearchContextEnricher {
    public void enrich(SearchContext searchContext, Object target) {
        LinkedList<Field> fields = new LinkedList<Field>();
        fields.addAll(ReflectionHelper.getFieldsWithAnnotation(target.getClass(), Page.class));
        for (Field field : fields) {
            Object page = this.createPage(searchContext, field.getAnnotations(), target, field, null, null);
            PageObjectEnricher.setValue(field, target, page);
        }
    }

    public Object[] resolve(SearchContext searchContext, Method method, Object[] resolvedParams) {
        LinkedList<Object[]> paramCouple = new LinkedList<Object[]>();
        paramCouple.addAll(ReflectionHelper.getParametersWithAnnotation(method, Page.class));
        for (int i = 0; i < resolvedParams.length; ++i) {
            Object page;
            if (paramCouple.get(i) == null) continue;
            Class param = (Class)((Object[])paramCouple.get(i))[0];
            Annotation[] parameterAnnotations = (Annotation[])((Object[])paramCouple.get(i))[1];
            resolvedParams[i] = page = this.createPage(searchContext, parameterAnnotations, null, null, method, param);
        }
        return resolvedParams;
    }

    private Object createPage(SearchContext searchContext, Annotation[] annotations, Object target, Field field, Method method, Class<?> param) {
        SearchContext localSearchContext;
        GrapheneContext grapheneContext;
        StringBuffer errorMsgBegin = new StringBuffer("");
        GrapheneContext grapheneContext2 = grapheneContext = searchContext == null ? null : ((GrapheneProxyInstance)searchContext).getGrapheneContext();
        if (grapheneContext == null) {
            grapheneContext = GrapheneContext.getContextFor(ReflectionHelper.getQualifier(annotations));
            localSearchContext = grapheneContext.getWebDriver(new Class[]{SearchContext.class});
        } else {
            localSearchContext = searchContext;
        }
        try {
            Class<?> declaredClass = target != null ? this.getDeclaredClass(target, field) : param;
            this.appendErrorMsgBegin(errorMsgBegin, declaredClass, target, method);
            return PageObjectEnricher.setupPage(grapheneContext, localSearchContext, declaredClass);
        }
        catch (NoSuchMethodException ex) {
            errorMsgBegin.append(" Check whether declared Page Object has no argument constructor!");
            throw new PageObjectInitializationException(errorMsgBegin.toString(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new PageObjectInitializationException(" Check whether declared Page Object has public no argument constructor!", ex);
        }
        catch (InstantiationException ex) {
            errorMsgBegin.append(" Check whether you did not declare Page Object with abstract type!");
            throw new PageObjectInitializationException(errorMsgBegin.toString(), ex);
        }
        catch (Exception ex) {
            throw new PageObjectInitializationException(errorMsgBegin.toString(), ex);
        }
    }

    private Class<?> getDeclaredClass(Object target, Field field) {
        Type type = field.getGenericType();
        if (type instanceof TypeVariable) {
            return this.getActualType(field, target);
        }
        return field.getType();
    }

    private void appendErrorMsgBegin(StringBuffer errorMsgBegin, Class<?> declaredClass, Object target, Method method) {
        errorMsgBegin.append("Can not instantiate Page Object ").append(NEW_LINE);
        errorMsgBegin.append(declaredClass).append(NEW_LINE);
        errorMsgBegin.append(" declared in: ").append(NEW_LINE);
        if (target != null) {
            errorMsgBegin.append(target.getClass().getName());
        } else {
            errorMsgBegin.append(method.getDeclaringClass().getClass().getName());
            errorMsgBegin.append("#").append(method.getName());
        }
        errorMsgBegin.append(NEW_LINE);
    }

    public static <P> P setupPage(GrapheneContext context, SearchContext searchContext, Class<?> pageClass) throws Exception {
        Object page = PageObjectEnricher.instantiate(pageClass, new Object[0]);
        Object proxy = GrapheneProxy.getProxyForHandler(GrapheneContextualHandler.forTarget(context, page), pageClass, new Class[0]);
        PageObjectEnricher.enrichRecursively(searchContext, page);
        PageObjectEnricher.enrichRecursively(searchContext, proxy);
        return (P)proxy;
    }

    public int getPrecedence() {
        return 1;
    }
}

