/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit.container;

import org.jboss.arquillian.junit.State;
import org.jboss.arquillian.junit.container.JUnitTestRunner;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.ExpectedException;

public class JUnitTestRunnerTestCase {
    @Test
    public void shouldReturnExceptionToClientIfAnnotatedExpectedAndPassing() throws Exception {
        State.caughtTestException((Throwable)new IllegalArgumentException());
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldPassAnnotatedExpected");
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(IllegalArgumentException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldNotReturnExceptionToClientIfAnnotatedExpectedAndFailingOnNoExceptionThrown() throws Exception {
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailAnnotatedExpected");
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionToClientIfAnnotatedExpectedAndFailingOnWrongExceptionThrown() throws Exception {
        State.caughtTestException((Throwable)new UnsupportedOperationException());
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailAnnotatedExpectedWrongException");
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(UnsupportedOperationException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldNotReturnExceptionToClientIfAsumptionPassing() throws Exception {
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldPassOnAssumption");
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionToClientIfAsumptionFailing() throws Exception {
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldSkipOnAssumption");
        Assert.assertEquals((Object)TestResult.Status.SKIPPED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(AssumptionViolatedException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldNotReturnExceptionToClientIfExpectedRulePassing() throws Exception {
        State.caughtTestException((Throwable)new IllegalArgumentException());
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldPassOnException");
        Assert.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assert.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionToClientIfExpectedRuleFailing() throws Exception {
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailOnException");
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(AssertionError.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnExceptionThrownInBeforeToClientWhenTestFails() throws Exception {
        Exception unexpectedException;
        Exception expectedException;
        TestScenarios.exceptionThrownInBefore = expectedException = new Exception("Expected");
        TestScenarios.exceptionThrownInAfter = unexpectedException = new Exception("Not expected");
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailOnException");
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertSame((Object)expectedException, (Object)result.getThrowable());
    }

    @Test
    public void shouldReturnAssertionErrorToClientWhenAfterThrowsException() throws Exception {
        Exception unexpectedException;
        TestScenarios.exceptionThrownInAfter = unexpectedException = new Exception("Not expected");
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailOnException");
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertNotNull((Object)result.getThrowable());
        Assert.assertEquals(AssertionError.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnExceptionThrownInAfterClientWhenTestSucceeds() throws Exception {
        Exception expectedException;
        TestScenarios.exceptionThrownInAfter = expectedException = new Exception("Expected");
        JUnitTestRunner runner = new JUnitTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldSucceed");
        Assert.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertSame((Object)expectedException, (Object)result.getThrowable());
    }

    public static class TestScenarios {
        public static Exception exceptionThrownInBefore;
        public static Exception exceptionThrownInAfter;
        @Rule
        public ExpectedException e = ExpectedException.none();

        @Before
        public void throwExceptionInBefore() throws Exception {
            if (exceptionThrownInBefore != null) {
                Exception e = exceptionThrownInBefore;
                exceptionThrownInBefore = null;
                throw e;
            }
        }

        @After
        public void throwExceptionInAfter() throws Exception {
            if (exceptionThrownInAfter != null) {
                Exception e = exceptionThrownInAfter;
                exceptionThrownInAfter = null;
                throw e;
            }
        }

        @Test
        public void shouldSucceed() {
            Assert.assertTrue((boolean)true);
        }

        @Test
        public void shouldSkipOnAssumption() throws Exception {
            Assume.assumeTrue((boolean)false);
        }

        @Test
        public void shouldPassOnAssumption() throws Exception {
            Assume.assumeTrue((boolean)true);
        }

        @Test
        public void shouldFailOnException() throws Exception {
            this.e.expect(IllegalArgumentException.class);
        }

        @Test
        public void shouldPassOnException() throws Exception {
            this.e.expect(IllegalArgumentException.class);
            throw new IllegalArgumentException();
        }

        @Test(expected=IllegalArgumentException.class)
        public void shouldPassAnnotatedExpected() throws Exception {
            throw new IllegalArgumentException();
        }

        @Test(expected=IllegalArgumentException.class)
        public void shouldFailAnnotatedExpected() throws Exception {
        }

        @Test(expected=IllegalArgumentException.class)
        public void shouldFailAnnotatedExpectedWrongException() throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

