/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit.container;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.junit.event.AfterRules;
import org.jboss.arquillian.junit.event.BeforeRules;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptorBuilder;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class JUnitTestBaseClass {
    private static Map<Cycle, Integer> callbackCount = new HashMap<Cycle, Integer>();
    private static Map<Cycle, Throwable> callbackException = new HashMap<Cycle, Throwable>();

    public static void wasCalled(Cycle cycle) throws Throwable {
        if (!callbackCount.containsKey((Object)cycle)) {
            throw new RuntimeException("Unknown callback: " + (Object)((Object)cycle));
        }
        callbackCount.put(cycle, callbackCount.get((Object)cycle) + 1);
        if (callbackException.containsKey((Object)cycle)) {
            throw callbackException.get((Object)cycle);
        }
    }

    @After
    public void clearCallbacks() {
        callbackCount.clear();
        for (Cycle tmp : Cycle.values()) {
            callbackCount.put(tmp, 0);
        }
        callbackException.clear();
    }

    protected void executeAllLifeCycles(TestRunnerAdaptor adaptor) throws Exception {
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).fireCustomLifecycle((TestLifecycleEvent)Matchers.isA(BeforeRules.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).fireCustomLifecycle((TestLifecycleEvent)Matchers.isA(AfterRules.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).beforeClass((Class)Matchers.any(Class.class), (LifecycleMethodExecutor)Matchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).afterClass((Class)Matchers.any(Class.class), (LifecycleMethodExecutor)Matchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).before(Matchers.any(Object.class), (Method)Matchers.any(Method.class), (LifecycleMethodExecutor)Matchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).after(Matchers.any(Object.class), (Method)Matchers.any(Method.class), (LifecycleMethodExecutor)Matchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new TestExecuteLifecycle(TestResult.passed())).when((Object)adaptor)).test((TestMethodExecutor)Matchers.any(TestMethodExecutor.class));
    }

    public void assertCycle(int count, Cycle ... cycles) {
        for (Cycle cycle : cycles) {
            Assert.assertEquals((String)("Verify " + (Object)((Object)cycle) + " called N times"), (long)count, (long)callbackCount.get((Object)cycle).intValue());
        }
    }

    protected Result run(TestRunnerAdaptor adaptor, Class<?> ... classes) throws Exception {
        return this.run(adaptor, (RunListener)null, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result run(TestRunnerAdaptor adaptor, RunListener listener, Class<?> ... classes) throws Exception {
        try {
            this.setAdaptor(adaptor);
            JUnitCore core = new JUnitCore();
            if (listener != null) {
                core.addListener(listener);
            }
            Result result = core.run((Class[])classes);
            return result;
        }
        finally {
            this.setAdaptor(null);
        }
    }

    private void setAdaptor(TestRunnerAdaptor adaptor) throws Exception {
        Method method = TestRunnerAdaptorBuilder.class.getMethod("set", TestRunnerAdaptor.class);
        method.setAccessible(true);
        method.invoke(null, adaptor);
    }

    static {
        for (Cycle tmp : Cycle.values()) {
            callbackCount.put(tmp, 0);
        }
    }

    public static class TestExecuteLifecycle
    extends ExecuteLifecycle {
        private TestResult result;

        public TestExecuteLifecycle(TestResult result) {
            this.result = result;
        }

        @Override
        public Object answer(InvocationOnMock invocation) throws Throwable {
            super.answer(invocation);
            return this.result;
        }
    }

    public static class ExecuteLifecycle
    implements Answer<Object> {
        public Object answer(InvocationOnMock invocation) throws Throwable {
            for (Object argument : invocation.getArguments()) {
                if (argument instanceof LifecycleMethodExecutor) {
                    ((LifecycleMethodExecutor)argument).invoke();
                    continue;
                }
                if (argument instanceof TestMethodExecutor) {
                    ((TestMethodExecutor)argument).invoke(new Object[0]);
                    continue;
                }
                if (!(argument instanceof TestLifecycleEvent)) continue;
                ((TestLifecycleEvent)argument).getExecutor().invoke();
            }
            return null;
        }
    }

    public static enum Cycle {
        BEFORE_CLASS_RULE,
        BEFORE_RULE,
        BEFORE_CLASS,
        BEFORE,
        TEST,
        AFTER,
        AFTER_CLASS,
        AFTER_RULE,
        AFTER_CLASS_RULE;

    }
}

