/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit5.container;

import org.jboss.arquillian.junit5.IdentifiedTestException;
import org.jboss.arquillian.junit5.container.JUnitJupiterTestRunner;
import org.jboss.arquillian.junit5.container.TestScenarios;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JUnitJupiterTestRunnerTestCase {
    @Test
    public void shouldReturnExceptionToClientIfFailingOnWrongExceptionThrown() {
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailExpectedWrongException");
        Assertions.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assertions.assertNotNull((Object)result.getThrowable());
        Assertions.assertEquals(IdentifiedTestException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldNotReturnExceptionToClientIfAsumptionPassing() throws Exception {
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldPassOnAssumption");
        Assertions.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assertions.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionToClientIfAsumptionFailing() throws Exception {
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldSkipOnAssumption");
        Assertions.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assertions.assertNotNull((Object)result.getThrowable());
        Assertions.assertEquals(IdentifiedTestException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldNotReturnExceptionToClientIfExpectedRulePassing() throws Exception {
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldPassOnException");
        Assertions.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assertions.assertNull((Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionToClientIfExpectedRuleFailing() throws Exception {
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailOnException");
        Assertions.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assertions.assertNotNull((Object)result.getThrowable());
        Assertions.assertEquals(IdentifiedTestException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnExceptionThrownInBeforeToClientWhenTestFails() throws Exception {
        Exception unexpectedException;
        Exception expectedException;
        TestScenarios.exceptionThrownInBefore = expectedException = new Exception("Expected");
        TestScenarios.exceptionThrownInAfter = unexpectedException = new Exception("Not expected");
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailOnException");
        Assertions.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assertions.assertEquals(IdentifiedTestException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnAssertionErrorToClientWhenAfterThrowsException() throws Exception {
        Exception unexpectedException;
        TestScenarios.exceptionThrownInAfter = unexpectedException = new Exception("Not expected");
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldFailOnException");
        Assertions.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assertions.assertNotNull((Object)result.getThrowable());
        Assertions.assertEquals(IdentifiedTestException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldReturnExceptionThrownInAfterClientWhenTestSucceeds() throws Exception {
        Exception expectedException;
        TestScenarios.exceptionThrownInAfter = expectedException = new Exception("Expected");
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.class, "shouldSucceed");
        Assertions.assertEquals((Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assertions.assertEquals(IdentifiedTestException.class, result.getThrowable().getClass());
    }

    @Test
    public void shouldNotReturnExceptionToClientIfAssumptionIsPassingInNestedClass() throws Exception {
        JUnitJupiterTestRunner runner = new JUnitJupiterTestRunner();
        TestResult result = runner.execute(TestScenarios.NestedTestScenarios.class, "shouldPassOnAssumptionInNested");
        Assertions.assertEquals((Object)TestResult.Status.PASSED, (Object)result.getStatus());
        Assertions.assertNull((Object)result.getThrowable());
    }
}

