/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit5.container;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.TestRunnerAdaptor;
import org.jboss.arquillian.test.spi.TestRunnerAdaptorBuilder;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class JUnitTestBaseClass {
    private static final Map<Cycle, Integer> callbackCount = new HashMap<Cycle, Integer>();
    private static final Map<Cycle, Exception> callbackException = new HashMap<Cycle, Exception>();

    public static void wasCalled(Cycle cycle) throws Exception {
        if (!callbackCount.containsKey((Object)cycle)) {
            throw new RuntimeException("Unknown callback: " + (Object)((Object)cycle));
        }
        callbackCount.put(cycle, callbackCount.get((Object)cycle) + 1);
        if (callbackException.containsKey((Object)cycle)) {
            throw callbackException.get((Object)cycle);
        }
    }

    @AfterEach
    public void clearCallbacks() {
        callbackCount.clear();
        for (Cycle tmp : Cycle.values()) {
            callbackCount.put(tmp, 0);
        }
        callbackException.clear();
    }

    protected void executeAllLifeCycles(TestRunnerAdaptor adaptor) throws Exception {
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).beforeClass((Class)ArgumentMatchers.any(Class.class), (LifecycleMethodExecutor)ArgumentMatchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).afterClass((Class)ArgumentMatchers.any(Class.class), (LifecycleMethodExecutor)ArgumentMatchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).before(ArgumentMatchers.any(Object.class), (Method)ArgumentMatchers.any(Method.class), (LifecycleMethodExecutor)ArgumentMatchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new ExecuteLifecycle()).when((Object)adaptor)).after(ArgumentMatchers.any(Object.class), (Method)ArgumentMatchers.any(Method.class), (LifecycleMethodExecutor)ArgumentMatchers.any(LifecycleMethodExecutor.class));
        ((TestRunnerAdaptor)Mockito.doAnswer((Answer)new TestExecuteLifecycle(TestResult.passed())).when((Object)adaptor)).test((TestMethodExecutor)ArgumentMatchers.any(TestMethodExecutor.class));
    }

    public void assertCycle(int count, Cycle ... cycles) {
        for (Cycle cycle : cycles) {
            Assertions.assertEquals((int)count, (int)callbackCount.get((Object)cycle), (String)("Verify " + (Object)((Object)cycle) + " called N times"));
        }
    }

    protected TestExecutionSummary run(TestRunnerAdaptor adaptor, Class<?> ... classes) throws Exception {
        return this.run(adaptor, (TestExecutionListener)null, classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TestExecutionSummary run(TestRunnerAdaptor adaptor, TestExecutionListener listener, Class<?> ... classes) throws Exception {
        try {
            this.setAdaptor(adaptor);
            LauncherDiscoveryRequestBuilder builder = LauncherDiscoveryRequestBuilder.request();
            for (Class<?> clazz : classes) {
                builder = builder.selectors(new DiscoverySelector[]{DiscoverySelectors.selectClass(clazz)});
            }
            LauncherDiscoveryRequest request = builder.build();
            SummaryGeneratingListener summaryListener = new SummaryGeneratingListener();
            Launcher launcher = LauncherFactory.create();
            launcher.registerTestExecutionListeners(new TestExecutionListener[]{summaryListener});
            if (listener != null) {
                launcher.registerTestExecutionListeners(new TestExecutionListener[]{listener});
            }
            launcher.execute(request, new TestExecutionListener[0]);
            TestExecutionSummary testExecutionSummary = summaryListener.getSummary();
            return testExecutionSummary;
        }
        finally {
            this.setAdaptor(null);
        }
    }

    private void setAdaptor(TestRunnerAdaptor adaptor) throws Exception {
        Method method = TestRunnerAdaptorBuilder.class.getMethod("set", TestRunnerAdaptor.class);
        method.invoke(null, adaptor);
    }

    static {
        for (Cycle tmp : Cycle.values()) {
            callbackCount.put(tmp, 0);
        }
    }

    public static class TestExecuteLifecycle
    extends ExecuteLifecycle {
        private final TestResult result;

        public TestExecuteLifecycle(TestResult result) {
            this.result = result;
        }

        @Override
        public Object answer(InvocationOnMock invocation) throws Throwable {
            super.answer(invocation);
            return this.result;
        }
    }

    public static class ExecuteLifecycle
    implements Answer<Object> {
        public Object answer(InvocationOnMock invocation) throws Throwable {
            for (Object argument : invocation.getArguments()) {
                if (argument instanceof LifecycleMethodExecutor) {
                    ((LifecycleMethodExecutor)argument).invoke();
                    continue;
                }
                if (argument instanceof TestMethodExecutor) {
                    ((TestMethodExecutor)argument).invoke(new Object[0]);
                    continue;
                }
                if (!(argument instanceof TestLifecycleEvent)) continue;
                ((TestLifecycleEvent)argument).getExecutor().invoke();
            }
            return null;
        }
    }

    public static enum Cycle {
        BEFORE_CLASS_RULE,
        BEFORE_RULE,
        BEFORE_CLASS,
        BEFORE,
        TEST,
        AFTER,
        AFTER_CLASS,
        AFTER_RULE,
        AFTER_CLASS_RULE;

    }
}

