/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.junit5.container;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class TestScenarios {
    public static Exception exceptionThrownInBefore;
    public static Exception exceptionThrownInAfter;

    @BeforeEach
    public void throwExceptionInBefore() throws Exception {
        if (exceptionThrownInBefore != null) {
            Exception e = exceptionThrownInBefore;
            exceptionThrownInBefore = null;
            throw e;
        }
    }

    @AfterEach
    public void throwExceptionInAfter() throws Exception {
        if (exceptionThrownInAfter != null) {
            Exception e = exceptionThrownInAfter;
            exceptionThrownInAfter = null;
            throw e;
        }
    }

    @Test
    public void shouldSucceed() {
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void shouldSkipOnAssumption() {
        Assumptions.assumeTrue((boolean)false);
    }

    @Test
    public void shouldPassOnAssumption() {
        Assumptions.assumeTrue((boolean)true);
    }

    @Test
    public void shouldPassOnException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            throw new IllegalArgumentException();
        });
    }

    @Test
    public void shouldFailOnException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {});
    }

    @Test
    public void shouldFailExpectedWrongException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            throw new UnsupportedOperationException();
        });
    }

    @Nested
    class NestedTestScenarios {
        NestedTestScenarios() {
        }

        @Test
        public void shouldPassOnAssumptionInNested() {
            Assumptions.assumeTrue((boolean)true);
        }
    }
}

