/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.packager.javaee;

import java.util.Collection;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EEDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(Archive<?> applicationArchive, Collection<Archive<?>> auxiliaryArchives) {
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive), auxiliaryArchives);
        }
        if (WebArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((WebArchive)WebArchive.class.cast(applicationArchive), auxiliaryArchives);
        }
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(applicationArchive), auxiliaryArchives);
        }
        throw new IllegalArgumentException(EEDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives) {
        if (this.containsArchiveOfType(WebArchive.class, auxiliaryArchives)) {
            throw new IllegalArgumentException("Can not merge two " + WebArchive.class.getName() + "'s. " + "Please verify that your using the correct protocol extensions, " + "or try deploying as a " + EnterpriseArchive.class.getName() + " instead");
        }
        return applicationArchive.addLibraries(auxiliaryArchives.toArray(new Archive[0]));
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives) {
        if (this.containsArchiveOfType(WebArchive.class, auxiliaryArchives)) {
            EnterpriseArchive deployment = (EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create((String)"test.ear", EnterpriseArchive.class)).addModule((Archive)applicationArchive);
            for (Archive<?> moduleArchive : auxiliaryArchives) {
                if (WebArchive.class.isInstance(moduleArchive)) {
                    deployment.addModule(moduleArchive);
                    continue;
                }
                deployment.addLibrary(moduleArchive);
            }
            return deployment;
        }
        WebArchive deployment = (WebArchive)ShrinkWrap.create((String)"test.war", WebArchive.class);
        deployment.addLibraries(auxiliaryArchives.toArray(new Archive[0]));
        deployment.addLibraries(new Archive[]{applicationArchive});
        return deployment;
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives) {
        if (!this.containsArchiveOfType(WebArchive.class, auxiliaryArchives)) {
            for (Archive<?> moduleArchive : auxiliaryArchives) {
                if ("arquillian-protocol.jar".equals(moduleArchive.getName()) && JavaArchive.class.isInstance(moduleArchive)) {
                    applicationArchive.addModule(((WebArchive)ShrinkWrap.create((String)"test.war", WebArchive.class)).addLibraries(new Archive[]{moduleArchive}));
                    continue;
                }
                applicationArchive.addLibrary(moduleArchive);
            }
        } else {
            for (Archive<?> moduleArchive : auxiliaryArchives) {
                if (WebArchive.class.isInstance(moduleArchive)) {
                    applicationArchive.addModule(moduleArchive);
                    continue;
                }
                applicationArchive.addLibrary(moduleArchive);
            }
        }
        return applicationArchive;
    }

    private boolean containsArchiveOfType(Class<? extends Archive<?>> clazz, Collection<Archive<?>> archives) {
        for (Archive<?> archive : archives) {
            if (!clazz.isInstance(archive)) continue;
            return true;
        }
        return false;
    }
}

