/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.TestMethodExecutor;
import org.jboss.arquillian.spi.TestResult;

public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private final MBeanServerConnection mbeanServer;
    private final ExecutionType executionType;
    private final Map<String, String> props;

    public JMXMethodExecutor(MBeanServerConnection connection, ExecutionType executionType) {
        this.mbeanServer = connection;
        this.executionType = executionType;
        this.props = new HashMap<String, String>();
        this.props.put(ExecutionType.class.getName(), executionType.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor null");
        }
        Object testInstance = testMethodExecutor.getInstance();
        String testClass = testInstance.getClass().getName();
        String testMethod = testMethodExecutor.getMethod().getName();
        TestResult result = null;
        try {
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(JMXTestRunnerMBean.OBJECT_NAME, JMXTestRunnerMBean.class);
            if (this.executionType == ExecutionType.EMBEDDED) {
                InputStream resultStream = testRunner.runTestMethodEmbedded(testClass, testMethod, this.props);
                ObjectInputStream ois = new ObjectInputStream(resultStream);
                result = (TestResult)ois.readObject();
            } else if (this.executionType == ExecutionType.REMOTE) {
                result = testRunner.runTestMethod(testClass, testMethod, this.props);
            }
        }
        catch (Throwable e) {
            result = new TestResult(TestResult.Status.FAILED);
            result.setThrowable(e);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
        }
        return result;
    }

    private <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    public static enum ExecutionType {
        EMBEDDED,
        REMOTE;

    }
}

