/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.StandardMBean;
import org.jboss.arquillian.protocol.jmx.ExecutionTypeAssociation;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.spi.Logger;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.spi.util.TCCLActions;
import org.jboss.arquillian.spi.util.TestRunners;

public class JMXTestRunner
implements JMXTestRunnerMBean {
    private static Logger log = Logger.getLogger(JMXTestRunner.class);

    public void registerMBean(MBeanServer mbeanServer) throws JMException {
        StandardMBean mbean = new StandardMBean(this, JMXTestRunnerMBean.class);
        mbeanServer.registerMBean(mbean, OBJECT_NAME);
        log.fine("JMXTestRunner registered: " + OBJECT_NAME);
    }

    public void unregisterMBean(MBeanServer mbeanServer) throws JMException {
        if (mbeanServer.isRegistered(OBJECT_NAME)) {
            mbeanServer.unregisterMBean(OBJECT_NAME);
            log.fine("JMXTestRunner unregistered: " + OBJECT_NAME);
        }
    }

    protected TestClassLoader getTestClassLoader() {
        return new TestClassLoader(){

            @Override
            public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                return this.getClass().getClassLoader().loadClass(className);
            }

            @Override
            public ClassLoader getServiceClassLoader() {
                return this.getClass().getClassLoader();
            }
        };
    }

    @Override
    public TestResult runTestMethod(String className, String methodName, Map<String, String> props) {
        return this.runTestMethodInternal(className, methodName, props);
    }

    @Override
    public InputStream runTestMethodEmbedded(String className, String methodName, Map<String, String> props) {
        TestResult result = this.runTestMethodInternal(className, methodName, props);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(result);
            oos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot marshall response", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult runTestMethodInternal(String className, String methodName, Map<String, String> props) {
        TestResult testResult;
        JMXMethodExecutor.ExecutionType executionType = JMXMethodExecutor.ExecutionType.valueOf(props.get(JMXMethodExecutor.ExecutionType.class.getName()));
        ExecutionTypeAssociation.setExecutionType(executionType);
        ClassLoader serviceClassLoader = this.getTestClassLoader().getServiceClassLoader();
        TestRunner runner = TestRunners.getTestRunner((ClassLoader)serviceClassLoader);
        ClassLoader tccl = TCCLActions.getClassLoader();
        try {
            TestResult testResult2;
            TCCLActions.setClassLoader((ClassLoader)serviceClassLoader);
            Class<?> testClass = this.getTestClassLoader().loadTestClass(className);
            testResult = testResult2 = runner.execute(testClass, methodName);
        }
        catch (Throwable throwable) {
            try {
                TCCLActions.setClassLoader((ClassLoader)tccl);
                throw throwable;
            }
            catch (Throwable th) {
                return new TestResult(TestResult.Status.FAILED, th);
            }
        }
        TCCLActions.setClassLoader((ClassLoader)tccl);
        return testResult;
    }

    public static interface TestClassLoader {
        public Class<?> loadTestClass(String var1) throws ClassNotFoundException;

        public ClassLoader getServiceClassLoader();
    }
}

