/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.InputStream;
import java.io.ObjectInputStream;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.ContainerMethodExecutor;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.jmx.JMXProtocolConfiguration;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;

public class JMXMethodExecutor
implements ContainerMethodExecutor {
    private final MBeanServerConnection mbeanServer;
    private final JMXProtocolConfiguration.ExecutionType executionType;
    private final CommandCallback callback;

    public JMXMethodExecutor(MBeanServerConnection mbeanServer, JMXProtocolConfiguration.ExecutionType executionType, CommandCallback callbac) {
        this.mbeanServer = mbeanServer;
        this.executionType = executionType;
        this.callback = callbac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult invoke(TestMethodExecutor testMethodExecutor) {
        if (testMethodExecutor == null) {
            throw new IllegalArgumentException("TestMethodExecutor null");
        }
        String testClass = testMethodExecutor.getInstance().getClass().getName();
        String testMethod = testMethodExecutor.getMethod().getName();
        CallbackNotificationListener commandListener = null;
        ObjectName objectName = null;
        TestResult result = null;
        try {
            objectName = new ObjectName("jboss.arquillian:service=jmx-test-runner");
            commandListener = new CallbackNotificationListener(objectName);
            this.mbeanServer.addNotificationListener(objectName, commandListener, null, null);
            if (this.executionType == JMXProtocolConfiguration.ExecutionType.REMOTE) {
                result = (TestResult)this.mbeanServer.invoke(objectName, "runTestMethodRemote", new Object[]{testClass, testMethod}, new String[]{String.class.getName(), String.class.getName()});
            } else {
                InputStream resultStream = (InputStream)this.mbeanServer.invoke(objectName, "runTestMethodEmbedded", new Object[]{testClass, testMethod}, new String[]{String.class.getName(), String.class.getName()});
                ObjectInputStream ois = new ObjectInputStream(resultStream);
                result = (TestResult)ois.readObject();
            }
        }
        catch (Throwable e) {
            result = new TestResult(TestResult.Status.FAILED);
            result.setThrowable(e);
        }
        finally {
            result.setEnd(System.currentTimeMillis());
            if (objectName != null && commandListener != null) {
                try {
                    this.mbeanServer.removeNotificationListener(objectName, commandListener);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private <T> T getMBeanProxy(ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(this.mbeanServer, name, interf, false);
    }

    private class CallbackNotificationListener
    implements NotificationListener {
        private ObjectName serviceName;

        public CallbackNotificationListener(ObjectName serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            String eventMessage = notification.getMessage();
            Command command = Serializer.toObject(Command.class, (byte[])notification.getUserData());
            JMXMethodExecutor.this.callback.fired(command);
            try {
                JMXMethodExecutor.this.mbeanServer.invoke(this.serviceName, "push", new Object[]{eventMessage, Serializer.toByteArray(command)}, new String[]{String.class.getName(), byte[].class.getName()});
            }
            catch (Exception e) {
                throw new RuntimeException("Could not return command result for command " + command, e);
            }
        }
    }
}

