/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.util.TestRunners;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.logging.Logger;

public class JMXTestRunner
extends NotificationBroadcasterSupport
implements JMXTestRunnerMBean {
    private static Logger log = Logger.getLogger(JMXTestRunner.class);
    static MBeanServer localMBeanServer;
    private ConcurrentHashMap<String, Command<?>> events;
    private ThreadLocal<String> currentCall;
    private AtomicInteger integer = new AtomicInteger();
    private TestRunner exposedTestRunnerForTest;
    private TestClassLoader testClassLoader;

    public JMXTestRunner(TestClassLoader classLoader) {
        this.testClassLoader = classLoader;
        if (this.testClassLoader == null) {
            this.testClassLoader = new TestClassLoader(){

                @Override
                public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                    ClassLoader classLoader = JMXTestRunner.class.getClassLoader();
                    return classLoader.loadClass(className);
                }
            };
        }
        this.events = new ConcurrentHashMap();
        this.currentCall = new ThreadLocal();
    }

    public ObjectName registerMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName("jboss.arquillian:service=jmx-test-runner");
        mbeanServer.registerMBean(this, oname);
        log.debug((Object)("JMXTestRunner registered: " + oname));
        localMBeanServer = mbeanServer;
        return oname;
    }

    public void unregisterMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName("jboss.arquillian:service=jmx-test-runner");
        if (mbeanServer.isRegistered(oname)) {
            mbeanServer.unregisterMBean(oname);
            log.debug((Object)("JMXTestRunner unregistered: " + oname));
        }
        localMBeanServer = null;
    }

    @Override
    public TestResult runTestMethodRemote(String className, String methodName) {
        this.currentCall.set(className + methodName);
        return this.runTestMethodInternal(className, methodName);
    }

    @Override
    public InputStream runTestMethodEmbedded(String className, String methodName) {
        this.currentCall.set(className + methodName);
        TestResult result = this.runTestMethodInternal(className, methodName);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(result);
            oos.close();
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot marshall response", ex);
        }
    }

    private TestResult runTestMethodInternal(String className, String methodName) {
        try {
            TestRunner runner = this.exposedTestRunnerForTest;
            if (runner == null) {
                runner = TestRunners.getTestRunner((ClassLoader)JMXTestRunner.class.getClassLoader());
            }
            Class<?> testClass = this.testClassLoader.loadTestClass(className);
            TestResult testResult = runner.execute(testClass, methodName);
            return testResult;
        }
        catch (Throwable th) {
            return new TestResult(TestResult.Status.FAILED, th);
        }
    }

    public void setExposedTestRunnerForTest(TestRunner exposedTestRunnerForTest) {
        this.exposedTestRunnerForTest = exposedTestRunnerForTest;
    }

    @Override
    public void send(Command<?> command) {
        Notification notification = new Notification("arquillian-command", (Object)this, (long)this.integer.incrementAndGet(), this.currentCall.get());
        notification.setUserData(Serializer.toByteArray(command));
        this.sendNotification(notification);
    }

    @Override
    public Command<?> receive() {
        return this.events.get(this.currentCall.get());
    }

    @Override
    public void push(String eventId, byte[] command) {
        this.events.put(eventId, Serializer.toObject(Command.class, command));
    }

    public static interface TestClassLoader {
        public Class<?> loadTestClass(String var1) throws ClassNotFoundException;
    }
}

