/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.util.TestRunners;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.test.spi.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMXTestRunner
extends NotificationBroadcasterSupport
implements JMXTestRunnerMBean {
    private static Logger log = Logger.getLogger(JMXTestRunner.class.getName());
    static MBeanServer localMBeanServer;
    private ConcurrentHashMap<String, Command<?>> events;
    private ThreadLocal<String> currentCall;
    private AtomicInteger integer = new AtomicInteger();
    private TestRunner mockTestRunner;
    private TestClassLoader testClassLoader;

    public JMXTestRunner(TestClassLoader classLoader) {
        this.testClassLoader = classLoader;
        if (this.testClassLoader == null) {
            this.testClassLoader = new TestClassLoader(){

                @Override
                public Class<?> loadTestClass(String className) throws ClassNotFoundException {
                    ClassLoader classLoader = JMXTestRunner.class.getClassLoader();
                    return classLoader.loadClass(className);
                }
            };
        }
        this.events = new ConcurrentHashMap();
        this.currentCall = new InheritableThreadLocal<String>();
    }

    public ObjectName registerMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName("jboss.arquillian:service=jmx-test-runner");
        mbeanServer.registerMBean(this, oname);
        log.fine("JMXTestRunner registered: " + oname);
        localMBeanServer = mbeanServer;
        return oname;
    }

    public void unregisterMBean(MBeanServer mbeanServer) throws JMException {
        ObjectName oname = new ObjectName("jboss.arquillian:service=jmx-test-runner");
        if (mbeanServer.isRegistered(oname)) {
            mbeanServer.unregisterMBean(oname);
            log.fine("JMXTestRunner unregistered: " + oname);
        }
        localMBeanServer = null;
    }

    @Override
    public byte[] runTestMethod(String className, String methodName) {
        TestResult result = this.runTestMethodInternal(className, methodName);
        return Serializer.toByteArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult runTestMethodInternal(String className, String methodName) {
        this.currentCall.set(className + methodName);
        TestResult result = new TestResult();
        try {
            TestRunner runner = this.mockTestRunner;
            if (runner == null) {
                runner = TestRunners.getTestRunner((ClassLoader)this.getClass().getClassLoader());
            }
            log.fine("Load test class: " + className);
            Class<?> testClass = this.testClassLoader.loadTestClass(className);
            log.fine("Test class loaded from: " + testClass.getClassLoader());
            log.fine("Execute: " + className + "." + methodName);
            result = runner.execute(testClass, methodName);
        }
        catch (Throwable th) {
            result.setStatus(TestResult.Status.FAILED);
            result.setEnd(System.currentTimeMillis());
            result.setThrowable(th);
        }
        finally {
            log.fine("Result: " + result);
            if (result.getStatus() == TestResult.Status.FAILED) {
                log.log(Level.SEVERE, "Failed: " + className + "." + methodName, result.getThrowable());
            }
        }
        return result;
    }

    @Override
    public void send(Command<?> command) {
        Notification notification = new Notification("arquillian-command", (Object)this, (long)this.integer.incrementAndGet(), this.currentCall.get());
        notification.setUserData(Serializer.toByteArray(command));
        this.sendNotification(notification);
    }

    @Override
    public Command<?> receive() {
        return this.events.remove(this.currentCall.get());
    }

    @Override
    public void push(String eventId, byte[] command) {
        this.events.put(eventId, Serializer.toObject(Command.class, command));
    }

    protected String getCurrentCall() {
        return this.currentCall.get();
    }

    protected void setCurrentCall(String current) {
        this.currentCall.set(current);
    }

    void setExposedTestRunnerForTest(TestRunner mockTestRunner) {
        this.mockTestRunner = mockTestRunner;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TestClassLoader {
        public Class<?> loadTestClass(String var1) throws ClassNotFoundException;
    }
}

