/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.jmx.DummyTestCase;
import org.jboss.arquillian.protocol.jmx.JMXMethodExecutor;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;
import org.jboss.arquillian.protocol.jmx.JMXTestRunnerMBean;
import org.jboss.arquillian.protocol.jmx.Serializer;
import org.jboss.arquillian.protocol.jmx.test.JMXTestTestRunner;
import org.jboss.arquillian.protocol.jmx.test.MockTestRunner;
import org.jboss.arquillian.protocol.jmx.test.TestCommandCallback;
import org.jboss.arquillian.protocol.jmx.test.TestIntegerCommand;
import org.jboss.arquillian.protocol.jmx.test.TestStringCommand;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Assert;
import org.junit.Test;

public class JMXTestRunnerTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJMXTestRunner() throws Throwable {
        MBeanServer mbeanServer = this.getMBeanServer();
        JMXTestRunner jmxTestRunner = new JMXTestRunner(null);
        ObjectName oname = jmxTestRunner.registerMBean(mbeanServer);
        try {
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(mbeanServer, oname, JMXTestRunnerMBean.class);
            TestResult result = (TestResult)Serializer.toObject(TestResult.class, (byte[])testRunner.runTestMethod(DummyTestCase.class.getName(), "testMethod", new HashMap()));
            Assert.assertNotNull((String)"TestResult not null", (Object)result);
            Assert.assertNotNull((String)"Status not null", (Object)result.getStatus());
            if (result.getStatus() == TestResult.Status.FAILED) {
                throw result.getThrowable();
            }
        }
        finally {
            mbeanServer.unregisterMBean(oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldInvokeOldRunMethodIfOldMethodIsOverridden() throws Throwable {
        MBeanServer mbeanServer = this.getMBeanServer();
        final AtomicInteger count = new AtomicInteger();
        JMXTestRunner jmxTestRunner = new JMXTestRunner(null){

            public byte[] runTestMethod(String className, String methodName) {
                count.incrementAndGet();
                return super.runTestMethod(className, methodName);
            }
        };
        ObjectName oname = jmxTestRunner.registerMBean(mbeanServer);
        try {
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(mbeanServer, oname, JMXTestRunnerMBean.class);
            TestResult result = (TestResult)Serializer.toObject(TestResult.class, (byte[])testRunner.runTestMethod(DummyTestCase.class.getName(), "testMethod", new HashMap()));
            Assert.assertNotNull((String)"TestResult not null", (Object)result);
            Assert.assertNotNull((String)"Status not null", (Object)result.getStatus());
            Assert.assertEquals((String)"Old runTestMethod should have been called", (long)1L, (long)count.get());
            if (result.getStatus() == TestResult.Status.FAILED) {
                throw result.getThrowable();
            }
        }
        finally {
            mbeanServer.unregisterMBean(oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldInvokeNewRunMethodIfNewMethodIsOverridden() throws Throwable {
        MBeanServer mbeanServer = this.getMBeanServer();
        final AtomicInteger count = new AtomicInteger();
        JMXTestRunner jmxTestRunner = new JMXTestRunner(null){

            public byte[] runTestMethod(String className, String methodName, Map<String, String> props) {
                count.incrementAndGet();
                return super.runTestMethod(className, methodName, props);
            }
        };
        ObjectName oname = jmxTestRunner.registerMBean(mbeanServer);
        try {
            JMXTestRunnerMBean testRunner = this.getMBeanProxy(mbeanServer, oname, JMXTestRunnerMBean.class);
            TestResult result = (TestResult)Serializer.toObject(TestResult.class, (byte[])testRunner.runTestMethod(DummyTestCase.class.getName(), "testMethod", new HashMap()));
            Assert.assertNotNull((String)"TestResult not null", (Object)result);
            Assert.assertNotNull((String)"Status not null", (Object)result.getStatus());
            Assert.assertEquals((String)"New runTestMethod should have been called", (long)1L, (long)count.get());
            if (result.getStatus() == TestResult.Status.FAILED) {
                throw result.getThrowable();
            }
        }
        finally {
            mbeanServer.unregisterMBean(oname);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToSendReceiveCommands() throws Throwable {
        Object[] results = new Object[]{"Success", 100};
        MockTestRunner.add(TestResult.passed());
        MockTestRunner.add(new TestStringCommand());
        MockTestRunner.add(new TestIntegerCommand());
        MBeanServer mbeanServer = this.getMBeanServer();
        JMXTestTestRunner jmxTestRunner = new JMXTestTestRunner(null);
        jmxTestRunner.setExposedTestRunnerForTest(new MockTestRunner());
        ObjectName oname = jmxTestRunner.registerMBean(mbeanServer);
        try {
            JMXMethodExecutor executor = new JMXMethodExecutor((MBeanServerConnection)mbeanServer, (CommandCallback)new TestCommandCallback(results));
            TestResult result = executor.invoke(new TestMethodExecutor(){

                public void invoke(Object ... parameters) throws Throwable {
                }

                public String getMethodName() {
                    return this.getMethod().getName();
                }

                public Method getMethod() {
                    return JMXTestRunnerTestCase.this.testMethod();
                }

                public Object getInstance() {
                    return JMXTestRunnerTestCase.this;
                }
            });
            Assert.assertNotNull((String)"TestResult not null", (Object)result);
            Assert.assertNotNull((String)"Status not null", (Object)result.getStatus());
            if (result.getStatus() == TestResult.Status.FAILED) {
                throw result.getThrowable();
            }
            for (int i = 0; i < results.length; ++i) {
                Assert.assertEquals((String)"Should have returned command", (Object)results[i], (Object)MockTestRunner.commandResults.get(i));
            }
        }
        finally {
            mbeanServer.unregisterMBean(oname);
        }
    }

    private MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> mbeanServers = MBeanServerFactory.findMBeanServer(null);
        MBeanServer mbeanServer = mbeanServers.size() < 1 ? MBeanServerFactory.createMBeanServer() : mbeanServers.get(0);
        return mbeanServer;
    }

    private <T> T getMBeanProxy(MBeanServer mbeanServer, ObjectName name, Class<T> interf) {
        return MBeanServerInvocationHandler.newProxyInstance(mbeanServer, name, interf, false);
    }

    private Method testMethod() {
        try {
            return DummyTestCase.class.getMethod("testMethod", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not lookup testMethod, check " + DummyTestCase.class, e);
        }
    }
}

