/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.arquillian.container.test.spi.command.Command;
import org.jboss.arquillian.container.test.spi.command.CommandService;
import org.jboss.arquillian.protocol.jmx.JMXTestRunner;

public class JMXCommandService
implements CommandService {
    private static long TIMEOUT = 30000L;

    public <T> T execute(Command<T> command) {
        MBeanServer server = JMXTestRunner.localMBeanServer;
        try {
            ObjectName runner = new ObjectName("jboss.arquillian:service=jmx-test-runner");
            server.invoke(runner, "send", new Object[]{command}, new String[]{Command.class.getName()});
            long timeoutTime = System.currentTimeMillis() + TIMEOUT;
            while (timeoutTime > System.currentTimeMillis()) {
                Command newCommand = (Command)server.invoke(runner, "receive", new Object[0], new String[0]);
                if (newCommand != null) {
                    if (newCommand.getThrowable() != null) {
                        throw new RuntimeException(newCommand.getThrowable());
                    }
                    if (newCommand.getResult() != null) {
                        return (T)newCommand.getResult();
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new RuntimeException("No command response within timeout of " + TIMEOUT + " ms.");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not communicate with client side", e);
        }
    }
}

