/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.protocol.rest.runner.RESTProtocolApplication;
import org.jboss.arquillian.protocol.rest.test.MockTestRunner;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.junit.After;
import org.junit.Before;

public class AbstractServerBase {
    Server server;

    @Before
    public void setup() throws Exception {
        int port = this.getAvailableLocalPort();
        this.server = new Server(port);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this.server, "/arquillian-protocol", 1);
        ServletHolder holder = new ServletHolder(HttpServletDispatcher.class);
        holder.setInitParameter("jakarta.ws.rs.Application", RESTProtocolApplication.class.getName());
        holder.setInitParameter("resteasy.servlet.mapping.prefix", "/ArquillianRESTRunnerEE9");
        root.addServlet(holder, "/ArquillianRESTRunnerEE9");
        this.server.start();
    }

    @After
    public void cleanup() throws Exception {
        MockTestRunner.clear();
        this.server.stop();
    }

    private int getAvailableLocalPort() throws IOException {
        try (ServerSocket socket = null;){
            socket = new ServerSocket(0);
            int n = socket.getLocalPort();
            return n;
        }
    }

    protected Collection<HTTPContext> createContexts() {
        ArrayList<HTTPContext> context = new ArrayList<HTTPContext>();
        context.add(this.createContext());
        return context;
    }

    protected HTTPContext createContext() {
        URI baseURI = this.createBaseURL();
        HTTPContext context = new HTTPContext(baseURI.getHost(), baseURI.getPort());
        context.add(new Servlet("ArquillianRESTRunnerEE9", baseURI.getPath()));
        return context;
    }

    protected URI createBaseURL() {
        NetworkConnector conn0 = (NetworkConnector)this.server.getConnectors()[0];
        return URI.create("http://localhost:" + conn0.getPort() + "/arquillian-protocol");
    }

    protected URL createURL(String outputMode, String testClass, String methodName) {
        StringBuilder url = new StringBuilder(this.createBaseURL().toASCIIString() + "/ArquillianRESTRunnerEE9");
        boolean first = true;
        if (outputMode != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("outputMode").append("=").append(outputMode);
        }
        if (testClass != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("className").append("=").append(testClass);
        }
        if (methodName != null) {
            if (first) {
                first = false;
                url.append("?");
            } else {
                url.append("&");
            }
            url.append("methodName").append("=").append(methodName);
        }
        try {
            return new URL(url.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create url", e);
        }
    }

    public static class MockTestExecutor
    implements TestMethodExecutor,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void invoke(Object ... parameters) throws Throwable {
        }

        public String getMethodName() {
            return this.getMethod().getName();
        }

        public Method getMethod() {
            try {
                return this.getClass().getMethod("getMethod", new Class[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not find my own method ?? ");
            }
        }

        public Object getInstance() {
            return this;
        }
    }
}

