/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.protocol.rest.RESTURIHandler;
import org.jboss.arquillian.protocol.servlet5.ServletProtocolConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class BaseRESTProtocolTestCase {
    @Test
    public void shouldFindTestServletInMetadata() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        HTTPContext testContext = new HTTPContext("127.0.0.1", 8080).add(new Servlet("ArquillianRESTRunnerEE9", "test"));
        Method testMethod = this.getTestMethod("testNoAnnotations");
        RESTURIHandler handler = new RESTURIHandler(config, this.to(testContext));
        URI result = handler.locateTestServlet(testMethod);
        Assert.assertEquals((Object)"http://127.0.0.1:8080/test", (Object)result.toString());
    }

    @Test
    public void shouldOverrideMetadata() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        config.setScheme("https");
        config.setHost("10.10.10.1");
        config.setPort(Integer.valueOf(90));
        HTTPContext testContext = new HTTPContext("127.0.0.1", 8080).add(new Servlet("ArquillianRESTRunnerEE9", "test"));
        Method testMethod = this.getTestMethod("testNoAnnotations");
        RESTURIHandler handler = new RESTURIHandler(config, this.to(testContext));
        URI result = handler.locateTestServlet(testMethod);
        Assert.assertEquals((Object)"https://10.10.10.1:90/test", (Object)result.toString());
    }

    @Test
    public void shouldMatchNamedTargetedContext() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        HTTPContext testContextOne = new HTTPContext("Y", "127.0.0.1", 8080).add(new Servlet("ArquillianRESTRunnerEE9", "test"));
        HTTPContext testContextTwo = new HTTPContext("X", "127.0.0.1", 8081).add(new Servlet("ArquillianRESTRunnerEE9", "test"));
        Method testMethod = this.getTestMethod("testTargeted");
        RESTURIHandler handler = new RESTURIHandler(config, this.to(testContextOne, testContextTwo));
        URI result = handler.locateTestServlet(testMethod);
        Assert.assertEquals((Object)"http://127.0.0.1:8081/test", (Object)result.toString());
    }

    @Test
    public void shouldOverrideMatchNamedTargetedContext() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        config.setScheme("https");
        config.setHost("10.10.10.1");
        config.setPort(Integer.valueOf(90));
        HTTPContext testContextOne = new HTTPContext("Y", "127.0.0.1", 8080).add(new Servlet("ArquillianRESTRunnerEE9", "testY"));
        HTTPContext testContextTwo = new HTTPContext("X", "127.0.0.1", 8081).add(new Servlet("ArquillianRESTRunnerEE9", "testX"));
        Method testMethod = this.getTestMethod("testTargeted");
        RESTURIHandler handler = new RESTURIHandler(config, this.to(testContextOne, testContextTwo));
        URI result = handler.locateTestServlet(testMethod);
        Assert.assertEquals((Object)"https://10.10.10.1:90/testX", (Object)result.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionOnMissingNamedTargetedContext() throws Exception {
        ServletProtocolConfiguration config = new ServletProtocolConfiguration();
        HTTPContext testContextOne = new HTTPContext("Y", "127.0.0.1", 8080).add(new Servlet("ArquillianRESTRunnerEE9", "test"));
        Method testMethod = this.getTestMethod("testTargeted");
        RESTURIHandler handler = new RESTURIHandler(config, this.to(testContextOne));
        handler.locateTestServlet(testMethod);
    }

    private Collection<HTTPContext> to(HTTPContext ... inputs) {
        ArrayList<HTTPContext> contexts = new ArrayList<HTTPContext>();
        Collections.addAll(contexts, inputs);
        return contexts;
    }

    private Method getTestMethod(String methodName) throws Exception {
        return this.getClass().getDeclaredMethod(methodName, new Class[0]);
    }

    private void testNoAnnotations() {
    }

    @TargetsContainer(value="X")
    private void testTargeted() {
    }
}

