/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.rest;

import java.net.URL;
import org.jboss.arquillian.container.test.spi.command.CommandCallback;
import org.jboss.arquillian.protocol.rest.AbstractServerBase;
import org.jboss.arquillian.protocol.rest.RESTMethodExecutor;
import org.jboss.arquillian.protocol.rest.TestUtil;
import org.jboss.arquillian.protocol.rest.test.MockTestRunner;
import org.jboss.arquillian.protocol.rest.test.TestCommandCallback;
import org.jboss.arquillian.protocol.servlet5.ServletProtocolConfiguration;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.Assert;
import org.junit.Test;

public class ProtocolTestCase
extends AbstractServerBase {
    @Test
    public void shouldReturnTestResult() throws Exception {
        MockTestRunner.add(TestResult.passed());
        RESTMethodExecutor executor = this.createExecutor();
        TestResult result = executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor());
        Assert.assertEquals((String)"Should have returned a passed test", (Object)MockTestRunner.wantedResults.getStatus(), (Object)result.getStatus());
        Assert.assertNull((String)"No Exception should have been thrown", (Object)result.getThrowable());
    }

    @Test
    public void shouldUseLogicalMethodNameAndSupportUrlReservedCharactersInIt() throws Exception {
        String testMethodNameWithReservedUrlCharacters = "non standard!test&name";
        MockTestRunner.add(TestResult.passed());
        RESTMethodExecutor executor = this.createExecutor();
        executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor(){

            @Override
            public String getMethodName() {
                return "non standard!test&name";
            }
        });
        Assert.assertEquals((String)"Should use the logical method name", (Object)"non standard!test&name", (Object)MockTestRunner.testRequests.get(0).getMethodName());
    }

    @Test
    public void shouldReturnThrownException() throws Exception {
        MockTestRunner.add(TestResult.failed((Throwable)new Exception().fillInStackTrace()));
        RESTMethodExecutor executor = this.createExecutor();
        TestResult result = executor.invoke((TestMethodExecutor)new AbstractServerBase.MockTestExecutor());
        Assert.assertEquals((String)"Should have returned a passed test", (Object)MockTestRunner.wantedResults.getStatus(), (Object)result.getStatus());
        Assert.assertNotNull((String)"Exception should have been thrown", (Object)result.getThrowable());
    }

    @Test
    public void shouldReturnExceptionWhenMissingTestClassParameter() throws Exception {
        URL url = this.createURL("serializedObject", null, null);
        TestResult result = (TestResult)TestUtil.execute(url);
        Assert.assertEquals((String)"Should have returned a passed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertTrue((String)"No Exception should have been thrown", (boolean)(result.getThrowable() instanceof IllegalArgumentException));
    }

    @Test
    public void shouldReturnExceptionWhenMissingMethodParameter() throws Exception {
        URL url = this.createURL("serializedObject", "org.my.test", null);
        TestResult result = (TestResult)TestUtil.execute(url);
        Assert.assertEquals((String)"Should have returned a passed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertTrue((String)"No Exception should have been thrown", (boolean)(result.getThrowable() instanceof IllegalArgumentException));
    }

    @Test
    public void shouldReturnExceptionWhenErrorLoadingClass() throws Exception {
        URL url = this.createURL("serializedObject", "org.my.test", "test");
        TestResult result = (TestResult)TestUtil.execute(url);
        Assert.assertEquals((String)"Should have returned a passed test", (Object)TestResult.Status.FAILED, (Object)result.getStatus());
        Assert.assertTrue((String)"No Exception should have been thrown", (boolean)(result.getThrowable() instanceof ClassNotFoundException));
    }

    protected RESTMethodExecutor createExecutor() {
        return new RESTMethodExecutor(new ServletProtocolConfiguration(), this.createContexts(), (CommandCallback)new TestCommandCallback(new Object[0]));
    }
}

