/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet_2_5;

import java.util.Collection;
import org.jboss.arquillian.protocol.servlet_2_5.ProtocolDeploymentAppender;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletProtocolDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment) {
        WebArchive protocol = (WebArchive)WebArchive.class.cast(new ProtocolDeploymentAppender().createAuxiliaryArchive());
        Archive applicationArchive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive), auxiliaryArchives, protocol);
        }
        if (WebArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((WebArchive)WebArchive.class.cast(applicationArchive), auxiliaryArchives, protocol);
        }
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(applicationArchive), auxiliaryArchives, protocol);
        }
        throw new IllegalArgumentException(ServletProtocolDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol) {
        throw new IllegalArgumentException("The " + ServletProtocolDeploymentPackager.class.getSimpleName() + " can't merge web.xml files.");
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol) {
        return ((EnterpriseArchive)((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"test.ear")).addModule((Archive)applicationArchive)).addModule((Archive)protocol)).addLibraries(auxiliaryArchives.toArray(new Archive[0]));
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol) {
        ((EnterpriseArchive)applicationArchive.addModule((Archive)protocol)).addLibraries(auxiliaryArchives.toArray(new Archive[0]));
        return applicationArchive;
    }
}

