/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.arquillian.protocol.servlet.SecurityActions;
import org.jboss.arquillian.spi.TestResult;
import org.jboss.arquillian.spi.TestRunner;
import org.jboss.arquillian.spi.util.TestRunners;

public class ServletTestRunner
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PARA_METHOD_NAME = "methodName";
    public static final String PARA_CLASS_NAME = "className";
    public static final String PARA_OUTPUT_MODE = "outputMode";
    public static final String OUTPUT_MODE_SERIALIZED = "serializedObject";
    public static final String OUTPUT_MODE_HTML = "html";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String outputMode = OUTPUT_MODE_HTML;
        try {
            String className = null;
            String methodName = null;
            if (request.getParameter(PARA_OUTPUT_MODE) != null) {
                outputMode = request.getParameter(PARA_OUTPUT_MODE);
            }
            if ((className = request.getParameter(PARA_CLASS_NAME)) == null) {
                throw new IllegalArgumentException("className must be specified");
            }
            methodName = request.getParameter(PARA_METHOD_NAME);
            if (methodName == null) {
                throw new IllegalArgumentException("methodName must be specified");
            }
            Class<?> testClass = SecurityActions.getThreadContextClassLoader().loadClass(className);
            TestRunner runner = TestRunners.getTestRunner();
            TestResult testResult = runner.execute(testClass, methodName);
            if (OUTPUT_MODE_SERIALIZED.equalsIgnoreCase(outputMode)) {
                this.writeObject(testResult, response);
            } else {
                response.setContentType("text/html");
                response.setStatus(200);
                PrintWriter writer = response.getWriter();
                writer.write("<html>\n");
                writer.write("<head><title>TCK Report</title></head>\n");
                writer.write("<body>\n");
                writer.write("<h2>Configuration</h2>\n");
                writer.write("<table>\n");
                writer.write("<tr>\n");
                writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
                writer.write("</tr>\n");
                writer.write("</table>\n");
                writer.write("<h2>Tests</h2>\n");
                writer.write("<table>\n");
                writer.write("<tr>\n");
                writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
                writer.write("</tr>\n");
                writer.write("</table>\n");
                writer.write("</body>\n");
            }
        }
        catch (Exception e) {
            if (OUTPUT_MODE_SERIALIZED.equalsIgnoreCase(outputMode)) {
                this.writeObject(this.createFailedResult(e), response);
            }
            response.sendError(500, e.getMessage());
        }
    }

    private void writeObject(Object object, HttpServletResponse response) {
        try {
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)response.getOutputStream());
            oos.writeObject(object);
            response.setStatus(200);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            try {
                response.sendError(500, e.getMessage());
            }
            catch (Exception e2) {
                throw new RuntimeException("Could not write to output", e2);
            }
        }
    }

    private TestResult createFailedResult(Throwable throwable) {
        return new TestResult(TestResult.Status.FAILED, throwable);
    }
}

