/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spock.container;

import java.util.Collections;
import java.util.List;
import org.jboss.arquillian.container.test.spi.TestRunner;
import org.jboss.arquillian.spock.ArquillianSputnik;
import org.jboss.arquillian.spock.container.SpockSpecificationFilter;
import org.jboss.arquillian.test.spi.TestResult;
import org.junit.runner.Result;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.spockframework.runtime.Sputnik;

public class SpockTestRunner
implements TestRunner {
    protected List<RunListener> getRunListeners() {
        return Collections.emptyList();
    }

    public TestResult execute(Class<?> testClass, String methodName) {
        Result testResult = new Result();
        try {
            ArquillianSputnik spockRunner = new ArquillianSputnik(testClass);
            spockRunner.filter((Filter)new SpockSpecificationFilter((Sputnik)spockRunner, methodName));
            this.runTest((Sputnik)spockRunner, testResult);
        }
        catch (Exception e) {
            return new TestResult(TestResult.Status.FAILED, (Throwable)e);
        }
        return this.convertToTestResult(testResult);
    }

    public void runTest(Sputnik spockRunner, Result testResult) {
        RunNotifier notifier = new RunNotifier();
        notifier.addFirstListener(testResult.createListener());
        for (RunListener listener : this.getRunListeners()) {
            notifier.addListener(listener);
        }
        spockRunner.run(notifier);
    }

    private TestResult convertToTestResult(Result result) {
        TestResult.Status status = TestResult.Status.PASSED;
        Throwable throwable = null;
        if (result.getFailureCount() > 0) {
            status = TestResult.Status.FAILED;
            throwable = ((Failure)result.getFailures().get(0)).getException();
        }
        if (result.getIgnoreCount() > 0) {
            status = TestResult.Status.SKIPPED;
        }
        return new TestResult(status, throwable);
    }
}

