/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl.enricher.resource;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.impl.enricher.resource.ArquillianResourceTestEnricher;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatcher;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.matchers.VarargMatcher;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArquillianResourceTestEnricherTestCase
extends AbstractTestTestBase {
    @Inject
    private Instance<Injector> injector;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ResourceProvider resourceProvider;
    @Mock
    private Object resource;

    @Before
    public void addServiceLoader() throws Exception {
        List<ResourceProvider> resourceProviders = Arrays.asList(this.resourceProvider);
        Mockito.when((Object)this.serviceLoader.all(ResourceProvider.class)).thenReturn(resourceProviders);
        Mockito.when((Object)this.resourceProvider.canProvide(Object.class)).thenReturn((Object)true);
        this.bind(ApplicationScoped.class, ServiceLoader.class, this.serviceLoader);
    }

    @Test
    public void shouldBeAbleToInjectBaseContext() throws Exception {
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)Mockito.any(), (Annotation[])Mockito.argThat((Matcher)new ClassInjectionAnnotationMatcher()))).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        ObjectClass test = new ObjectClass();
        enricher.enrich((Object)test);
        Assert.assertEquals((Object)this.resource, (Object)test.resource);
    }

    @Test
    public void shouldBeAbleToInjectBaseContextOnMethod() throws Exception {
        Method resourceMethod = ObjectClass.class.getMethod("test", Object.class);
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)Mockito.any(), (Annotation[])Mockito.argThat((Matcher)new MethodInjectionAnnotationMatcher()))).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        Object[] result = enricher.resolve(resourceMethod);
        Assert.assertEquals((Object)this.resource, (Object)result[0]);
    }

    @Test
    public void shouldBeAbleToInjectBaseContextWithQualifier() throws Exception {
        Field resource2Field = ObjectClass2.class.getField("resource2");
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)Mockito.any(), (Annotation[])Mockito.argThat((Matcher)new CustomAnnotationMatcher(resource2Field.getAnnotation(ArquillianTestQualifier.class), ResourceProvider.ClassInjection.class)))).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        ObjectClass2 test = new ObjectClass2();
        enricher.enrich((Object)test);
        Assert.assertEquals((Object)this.resource, (Object)test.resource2);
    }

    @Test
    public void shouldBeAbleToInjectBaseContextOnMethodWithQualifier() throws Exception {
        Method resourceMethod = ObjectClass.class.getMethod("testWithQualifier", Object.class);
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)Mockito.any(), (Annotation[])Mockito.argThat((Matcher)new CustomAnnotationMatcher(resourceMethod.getParameterAnnotations()[0][1], ResourceProvider.MethodInjection.class)))).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        Object[] result = enricher.resolve(resourceMethod);
        Assert.assertEquals((Object)this.resource, (Object)result[0]);
    }

    @Test
    public void shouldThrowExceptionWhenUsedMethodScopeInjectionOnArquillianResource() throws Exception {
        Method resourceMethod = ObjectClass3.class.getMethod("testWithInjectionQualifier", Object.class);
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)Mockito.any(), (Annotation[])Mockito.argThat((Matcher)new CustomAnnotationMatcher(resourceMethod.getParameterAnnotations()[0][1], ResourceProvider.MethodInjection.class)))).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        Exception cause = null;
        try {
            enricher.resolve(resourceMethod);
        }
        catch (Exception ex) {
            cause = ex;
        }
        Assert.assertEquals(IllegalStateException.class, cause.getClass());
    }

    @Test
    public void shouldThrowExceptionWhenUsedClassScopeInjectionOnArquillianResource() {
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)Mockito.any(), (Annotation[])Mockito.argThat((Matcher)new ClassInjectionAnnotationMatcher()))).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        ObjectClass3 test = new ObjectClass3();
        Throwable cause = null;
        try {
            enricher.enrich((Object)test);
        }
        catch (RuntimeException ex) {
            cause = ex.getCause();
        }
        Assert.assertEquals(IllegalStateException.class, cause.getClass());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomAnnotationMatcher
    extends ArgumentMatcher<Annotation[]>
    implements VarargMatcher {
        private static final long serialVersionUID = 7468313136186740343L;
        private Annotation additionalQualifier;
        private Class<? extends Annotation> injectionScope;

        public CustomAnnotationMatcher(Annotation additionalQualifier, Class<? extends Annotation> injectionScope) {
            this.additionalQualifier = additionalQualifier;
            this.injectionScope = injectionScope;
        }

        public boolean matches(Object varargArgument) {
            Annotation[] annotations = (Annotation[])varargArgument;
            return annotations.length == 2 && annotations[0].annotationType().equals(this.additionalQualifier.annotationType()) && annotations[1].annotationType().equals(this.injectionScope);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodInjectionAnnotationMatcher
    extends ArgumentMatcher<Annotation[]>
    implements VarargMatcher {
        private static final long serialVersionUID = 7468313136186740343L;

        private MethodInjectionAnnotationMatcher() {
        }

        public boolean matches(Object varargArgument) {
            Class<? extends Annotation> qualifier = ((Annotation)varargArgument).annotationType();
            return qualifier.equals(ResourceProvider.MethodInjection.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassInjectionAnnotationMatcher
    extends ArgumentMatcher<Annotation[]>
    implements VarargMatcher {
        private static final long serialVersionUID = 7468313136186740343L;

        private ClassInjectionAnnotationMatcher() {
        }

        public boolean matches(Object varargArgument) {
            Class<? extends Annotation> qualifier = ((Annotation)varargArgument).annotationType();
            return qualifier.equals(ResourceProvider.ClassInjection.class);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ArquillianTestQualifier {
    }

    public class ObjectClass3 {
        @ArquillianResource
        @ResourceProvider.ClassInjection
        public Object resource;

        public void testWithInjectionQualifier(@ArquillianResource @ResourceProvider.MethodInjection Object resource) {
        }
    }

    public class ObjectClass2 {
        @ArquillianResource
        @ArquillianTestQualifier
        public Object resource2;
    }

    public class ObjectClass {
        @ArquillianResource
        public Object resource;

        public void test(@ArquillianResource Object resource) {
        }

        public void testWithQualifier(@ArquillianResource @ArquillianTestQualifier Object resource) {
        }
    }
}

