/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl;

import java.lang.reflect.Method;
import java.util.List;
import org.jboss.arquillian.core.impl.ManagerImpl;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.test.impl.EventTestRunnerAdaptor;
import org.jboss.arquillian.test.impl.TestContextHandler;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.arquillian.test.spi.context.TestContext;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=MockitoJUnitRunner.class)
public class EventTestRunnerAdaptorTestCase
extends AbstractTestTestBase {
    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(TestContextHandler.class);
    }

    @Override
    protected void startContexts(Manager manager) {
    }

    @Test
    public void shouldHandleLifeCycleEvents() throws Exception {
        ManagerImpl manager = this.getManager();
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor((Manager)manager);
        Class<?> testClass = ((Object)((Object)this)).getClass();
        Method testMethod = testClass.getMethod("shouldHandleLifeCycleEvents", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getInstance()).thenReturn((Object)testInstance);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.beforeSuite();
        this.assertEventFired(BeforeSuite.class, 1);
        this.assertEventFiredInContext(BeforeSuite.class, SuiteContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.beforeClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(BeforeClass.class, 1);
        this.assertEventFiredInContext(BeforeClass.class, SuiteContext.class);
        this.assertEventFiredInContext(BeforeClass.class, ClassContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.before((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(Before.class, 1);
        this.assertEventFiredInContext(Before.class, SuiteContext.class);
        this.assertEventFiredInContext(Before.class, ClassContext.class);
        this.assertEventFiredInContext(Before.class, TestContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.test(testExecutor);
        this.assertEventFired(org.jboss.arquillian.test.spi.event.suite.Test.class, 1);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, SuiteContext.class);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, ClassContext.class);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, TestContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.after((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(After.class, 1);
        this.assertEventFiredInContext(After.class, SuiteContext.class);
        this.assertEventFiredInContext(After.class, ClassContext.class);
        this.assertEventFiredInContext(After.class, TestContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.afterClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(AfterClass.class, 1);
        this.assertEventFiredInContext(AfterClass.class, SuiteContext.class);
        this.assertEventFiredInContext(AfterClass.class, ClassContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.afterSuite();
        this.assertEventFired(AfterSuite.class, 1);
        this.assertEventFiredInContext(AfterSuite.class, SuiteContext.class);
        this.verifyNoActiveContext((Manager)manager);
    }

    private void verifyNoActiveContext(Manager manager) {
        this.verify(false, false, false, manager);
    }

    private void verify(boolean suite, boolean clazz, boolean test, Manager manager) {
        Assert.assertEquals((String)("SuiteContext should" + (!suite ? " not" : "") + " be active"), (Object)suite, (Object)((SuiteContext)manager.getContext(SuiteContext.class)).isActive());
        Assert.assertEquals((String)("ClassContext should" + (!clazz ? " not" : "") + " be active"), (Object)clazz, (Object)((ClassContext)manager.getContext(ClassContext.class)).isActive());
        Assert.assertEquals((String)("TestContext should" + (!test ? " not" : "") + " be active"), (Object)test, (Object)((TestContext)manager.getContext(TestContext.class)).isActive());
    }
}

