/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl.enricher.resource;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jboss.arquillian.core.api.Injector;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.impl.enricher.resource.ArquillianResourceTestEnricher;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ArquillianResourceTestEnricherTestCase
extends AbstractTestTestBase {
    @Inject
    private Instance<Injector> injector;
    @Mock
    private ServiceLoader serviceLoader;
    @Mock
    private ResourceProvider resourceProvider;
    @Mock
    private Object resource;

    @Before
    public void addServiceLoader() throws Exception {
        List<ResourceProvider> resourceProviders = Arrays.asList(this.resourceProvider);
        Mockito.when((Object)this.serviceLoader.all(ResourceProvider.class)).thenReturn(resourceProviders);
        Mockito.when((Object)this.resourceProvider.canProvide(Object.class)).thenReturn((Object)true);
        this.bind(ApplicationScoped.class, ServiceLoader.class, this.serviceLoader);
    }

    @Test
    public void shouldBeAbleToInjectBaseContext() throws Exception {
        Mockito.when((Object)this.resourceProvider.lookup(ObjectClass.class.getField("resource").getAnnotation(ArquillianResource.class), new Annotation[0])).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        ObjectClass test = new ObjectClass();
        enricher.enrich((Object)test);
        Assert.assertEquals((Object)this.resource, (Object)test.resource);
    }

    @Test
    public void shouldBeAbleToInjectBaseContextOnMethod() throws Exception {
        Method resourceMethod = ObjectClass.class.getMethod("test", Object.class);
        Annotation resourceAnnotation = resourceMethod.getParameterAnnotations()[0][0];
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)resourceAnnotation, new Annotation[0])).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        Object[] result = enricher.resolve(resourceMethod);
        Assert.assertEquals((Object)this.resource, (Object)result[0]);
    }

    @Test
    public void shouldBeAbleToInjectBaseContextWithQualifier() throws Exception {
        Field resource2Field = ObjectClass2.class.getField("resource2");
        Mockito.when((Object)this.resourceProvider.lookup(resource2Field.getAnnotation(ArquillianResource.class), new Annotation[]{resource2Field.getAnnotation(ArquillianTestQualifier.class)})).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        ObjectClass2 test = new ObjectClass2();
        enricher.enrich((Object)test);
        Assert.assertEquals((Object)this.resource, (Object)test.resource2);
    }

    @Test
    public void shouldBeAbleToInjectBaseContextOnMethodWithQualifier() throws Exception {
        Method resourceMethod = ObjectClass.class.getMethod("testWithQualifier", Object.class);
        Annotation resourceAnnotation = resourceMethod.getParameterAnnotations()[0][0];
        Mockito.when((Object)this.resourceProvider.lookup((ArquillianResource)resourceAnnotation, new Annotation[]{resourceMethod.getParameterAnnotations()[0][1]})).thenReturn(this.resource);
        ArquillianResourceTestEnricher enricher = new ArquillianResourceTestEnricher();
        ((Injector)this.injector.get()).inject((Object)enricher);
        Object[] result = enricher.resolve(resourceMethod);
        Assert.assertEquals((Object)this.resource, (Object)result[0]);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    public static @interface ArquillianTestQualifier {
    }

    public class ObjectClass2 {
        @ArquillianResource
        @ArquillianTestQualifier
        public Object resource2;
    }

    public class ObjectClass {
        @ArquillianResource
        public Object resource;

        public void test(@ArquillianResource Object resource) {
        }

        public void testWithQualifier(@ArquillianResource @ArquillianTestQualifier Object resource) {
        }
    }
}

