/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.impl.ManagerImpl;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.core.spi.context.ApplicationContext;
import org.jboss.arquillian.test.impl.EventTestRunnerAdaptor;
import org.jboss.arquillian.test.impl.TestContextHandler;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.TestMethodExecutor;
import org.jboss.arquillian.test.spi.TestResult;
import org.jboss.arquillian.test.spi.context.ClassContext;
import org.jboss.arquillian.test.spi.context.SuiteContext;
import org.jboss.arquillian.test.spi.context.TestContext;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.Before;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeTestLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.TestLifecycleEvent;
import org.jboss.arquillian.test.spi.execution.ExecutionDecision;
import org.jboss.arquillian.test.spi.execution.TestExecutionDecider;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class EventTestRunnerAdaptorTestCase
extends AbstractTestTestBase {
    private static final TestExecutionDecider NEGATIVE_EXECUTION_DECIDER = new TestExecutionDecider(){

        public ExecutionDecision decide(Method testMethod) {
            return ExecutionDecision.dontExecute((String)("Skipping execution of test method: " + testMethod.getName()));
        }

        public int precedence() {
            return 0;
        }
    };

    protected void addExtensions(List<Class<?>> extensions) {
        extensions.add(TestContextHandler.class);
    }

    @Override
    protected void startContexts(Manager manager) {
    }

    @Test
    public void shouldSkipWhenUsingExecutionDecider() throws Exception {
        ArrayList<TestExecutionDecider> deciders = new ArrayList<TestExecutionDecider>();
        deciders.add(NEGATIVE_EXECUTION_DECIDER);
        ServiceLoader serviceLoder = (ServiceLoader)Mockito.mock(ServiceLoader.class);
        Mockito.when((Object)serviceLoder.all(TestExecutionDecider.class)).thenReturn(deciders);
        Manager manager = (Manager)Mockito.spy((Object)this.getManager());
        Mockito.when((Object)((ServiceLoader)manager.resolve(ServiceLoader.class))).thenReturn((Object)serviceLoder);
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor(manager);
        Class<?> testClass = ((Object)((Object)this)).getClass();
        Method testMethod = testClass.getMethod("shouldSkipWhenUsingExecutionDecider", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        ((ApplicationContext)manager.getContext(ApplicationContext.class)).deactivate();
        this.verifyNoActiveContext(manager);
        adaptor.beforeSuite();
        this.assertEventFired(BeforeSuite.class, 1);
        this.assertEventFiredInContext(BeforeSuite.class, ApplicationContext.class);
        this.assertEventFiredInContext(BeforeSuite.class, SuiteContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.beforeClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(BeforeClass.class, 1);
        this.assertEventFiredInContext(BeforeClass.class, ApplicationContext.class);
        this.assertEventFiredInContext(BeforeClass.class, SuiteContext.class);
        this.assertEventFiredInContext(BeforeClass.class, ClassContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.before((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(Before.class, 0);
        this.assertEventNotFiredInContext(Before.class, ApplicationContext.class);
        this.assertEventNotFiredInContext(Before.class, SuiteContext.class);
        this.assertEventNotFiredInContext(Before.class, ClassContext.class);
        this.assertEventNotFiredInContext(Before.class, TestContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.test(testExecutor);
        this.assertEventFired(org.jboss.arquillian.test.spi.event.suite.Test.class, 0);
        this.assertEventNotFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, ApplicationContext.class);
        this.assertEventNotFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, SuiteContext.class);
        this.assertEventNotFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, ClassContext.class);
        this.assertEventNotFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, TestContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.after((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(After.class, 0);
        this.assertEventNotFiredInContext(After.class, ApplicationContext.class);
        this.assertEventNotFiredInContext(After.class, SuiteContext.class);
        this.assertEventNotFiredInContext(After.class, ClassContext.class);
        this.assertEventNotFiredInContext(After.class, TestContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.fireCustomLifecycle((TestLifecycleEvent)new BeforeTestLifecycleEvent((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP));
        this.assertEventFired(BeforeTestLifecycleEvent.class, 0);
        this.assertEventNotFiredInContext(BeforeTestLifecycleEvent.class, ApplicationContext.class);
        this.assertEventNotFiredInContext(BeforeTestLifecycleEvent.class, SuiteContext.class);
        this.assertEventNotFiredInContext(BeforeTestLifecycleEvent.class, ClassContext.class);
        this.assertEventNotFiredInContext(BeforeTestLifecycleEvent.class, TestContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.afterClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(AfterClass.class, 1);
        this.assertEventFiredInContext(AfterClass.class, ApplicationContext.class);
        this.assertEventFiredInContext(AfterClass.class, SuiteContext.class);
        this.assertEventFiredInContext(AfterClass.class, ClassContext.class);
        this.verifyNoActiveContext(manager);
        adaptor.afterSuite();
        this.assertEventFired(AfterSuite.class, 1);
        this.assertEventFiredInContext(AfterSuite.class, ApplicationContext.class);
        this.assertEventFiredInContext(AfterSuite.class, SuiteContext.class);
        this.verifyNoActiveContext(manager);
    }

    @Test
    public void shouldHandleLifeCycleEvents() throws Exception {
        ManagerImpl manager = this.getManager();
        manager.bind(ApplicationScoped.class, TestResult.class, (Object)TestResult.passed());
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor((Manager)manager);
        Class<?> testClass = ((Object)((Object)this)).getClass();
        Method testMethod = testClass.getMethod("shouldHandleLifeCycleEvents", new Class[0]);
        EventTestRunnerAdaptorTestCase testInstance = this;
        TestMethodExecutor testExecutor = (TestMethodExecutor)Mockito.mock(TestMethodExecutor.class);
        Mockito.when((Object)testExecutor.getInstance()).thenReturn((Object)testInstance);
        Mockito.when((Object)testExecutor.getMethod()).thenReturn((Object)testMethod);
        ((ApplicationContext)manager.getContext(ApplicationContext.class)).deactivate();
        this.verifyNoActiveContext((Manager)manager);
        adaptor.beforeSuite();
        this.assertEventFired(BeforeSuite.class, 1);
        this.assertEventFiredInContext(BeforeSuite.class, ApplicationContext.class);
        this.assertEventFiredInContext(BeforeSuite.class, SuiteContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.beforeClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(BeforeClass.class, 1);
        this.assertEventFiredInContext(BeforeClass.class, ApplicationContext.class);
        this.assertEventFiredInContext(BeforeClass.class, SuiteContext.class);
        this.assertEventFiredInContext(BeforeClass.class, ClassContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.before((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(Before.class, 1);
        this.assertEventFiredInContext(Before.class, ApplicationContext.class);
        this.assertEventFiredInContext(Before.class, SuiteContext.class);
        this.assertEventFiredInContext(Before.class, ClassContext.class);
        this.assertEventFiredInContext(Before.class, TestContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.test(testExecutor);
        this.assertEventFired(org.jboss.arquillian.test.spi.event.suite.Test.class, 1);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, ApplicationContext.class);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, SuiteContext.class);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, ClassContext.class);
        this.assertEventFiredInContext(org.jboss.arquillian.test.spi.event.suite.Test.class, TestContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.after((Object)testInstance, testMethod, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(After.class, 1);
        this.assertEventFiredInContext(After.class, ApplicationContext.class);
        this.assertEventFiredInContext(After.class, SuiteContext.class);
        this.assertEventFiredInContext(After.class, ClassContext.class);
        this.assertEventFiredInContext(After.class, TestContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.afterClass(testClass, LifecycleMethodExecutor.NO_OP);
        this.assertEventFired(AfterClass.class, 1);
        this.assertEventFiredInContext(AfterClass.class, ApplicationContext.class);
        this.assertEventFiredInContext(AfterClass.class, SuiteContext.class);
        this.assertEventFiredInContext(AfterClass.class, ClassContext.class);
        this.verifyNoActiveContext((Manager)manager);
        adaptor.afterSuite();
        this.assertEventFired(AfterSuite.class, 1);
        this.assertEventFiredInContext(AfterSuite.class, ApplicationContext.class);
        this.assertEventFiredInContext(AfterSuite.class, SuiteContext.class);
        this.verifyNoActiveContext((Manager)manager);
    }

    private void verifyNoActiveContext(Manager manager) {
        this.verify(false, false, false, false, manager);
    }

    private void verify(boolean application, boolean suite, boolean clazz, boolean test, Manager manager) {
        Assert.assertEquals((String)("ApplicationContext should" + (!application ? " not" : "") + " be active"), (Object)application, (Object)((ApplicationContext)manager.getContext(ApplicationContext.class)).isActive());
        Assert.assertEquals((String)("SuiteContext should" + (!suite ? " not" : "") + " be active"), (Object)suite, (Object)((SuiteContext)manager.getContext(SuiteContext.class)).isActive());
        Assert.assertEquals((String)("ClassContext should" + (!clazz ? " not" : "") + " be active"), (Object)clazz, (Object)((ClassContext)manager.getContext(ClassContext.class)).isActive());
        Assert.assertEquals((String)("TestContext should" + (!test ? " not" : "") + " be active"), (Object)test, (Object)((TestContext)manager.getContext(TestContext.class)).isActive());
    }
}

