/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.impl;

import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observer;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.Manager;
import org.jboss.arquillian.test.impl.EventTestRunnerAdaptor;
import org.jboss.arquillian.test.spi.LifecycleMethodExecutor;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.test.AbstractTestTestBase;
import org.junit.Assert;
import org.junit.Test;

public class AdditionalTestClassObserverTestCase
extends AbstractTestTestBase {
    @Test
    public void should_add_observers_to_list_of_extensions() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor((Manager)this.getManager());
        adaptor.beforeClass(TestClassWithTwoObservers.class, LifecycleMethodExecutor.NO_OP);
        this.verifyObserverPresence(ObserverClass.class, true);
        this.verifyObserverPresence(EmptyObserverClass.class, true);
    }

    @Test
    public void should_remove_observers_from_list_of_extensions_in_after_class_phase() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor((Manager)this.getManager());
        adaptor.beforeClass(TestClassWithTwoObservers.class, LifecycleMethodExecutor.NO_OP);
        adaptor.afterClass(TestClassWithTwoObservers.class, LifecycleMethodExecutor.NO_OP);
        this.verifyObserverPresence(ObserverClass.class, false);
        this.verifyObserverPresence(EmptyObserverClass.class, false);
    }

    @Test
    public void should_invoke_additionally_added_observer_and_inject_value_to_variable() throws Exception {
        EventTestRunnerAdaptor adaptor = new EventTestRunnerAdaptor((Manager)this.getManager());
        adaptor.beforeClass(TestClassWithTwoObservers.class, LifecycleMethodExecutor.NO_OP);
        InvokedInfo invokedInfo = new InvokedInfo();
        this.getManager().bind(ClassScoped.class, InvokedInfo.class, (Object)invokedInfo);
        this.getManager().fire((Object)new MyEvent());
        Assert.assertTrue((String)"The observer should be invoked but wasn't", (boolean)invokedInfo.isInvoked());
    }

    private void verifyObserverPresence(Class<?> observerClass, boolean shouldBePresent) {
        Object observer = this.getManager().getExtension(observerClass);
        if (shouldBePresent) {
            Assert.assertNotNull((String)("the observer of type " + observerClass.getName() + " should be present"), (Object)observer);
        } else {
            Assert.assertNull((String)("the observer of type " + observerClass.getName() + " should NOT be present"), (Object)observer);
        }
    }

    @Observer(value={EmptyObserverClass.class, ObserverClass.class})
    private static class TestClassWithTwoObservers {
        private TestClassWithTwoObservers() {
        }
    }

    private static class ObserverClass {
        @Inject
        private Instance<InvokedInfo> invokedInfoInstance;

        private ObserverClass() {
        }

        void observe(@Observes MyEvent event) {
            ((InvokedInfo)this.invokedInfoInstance.get()).setInvoked(true);
        }
    }

    private static class EmptyObserverClass {
        private EmptyObserverClass() {
        }
    }

    private static class InvokedInfo {
        private boolean invoked = false;

        private InvokedInfo() {
        }

        private boolean isInvoked() {
            return this.invoked;
        }

        private void setInvoked(boolean invoked) {
            this.invoked = invoked;
        }
    }

    private static class MyEvent {
        private MyEvent() {
        }
    }
}

