/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.test.spi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.arquillian.test.spi.CombinedException;
import org.jboss.arquillian.test.spi.ExceptionProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Status status;
    private String description = "";
    private transient Throwable throwable;
    private ExceptionProxy exceptionProxy;
    private long start;
    private long end;

    public static TestResult passed() {
        return new TestResult(Status.PASSED);
    }

    public static TestResult passed(String description) {
        return new TestResult(Status.PASSED, description);
    }

    public static TestResult skipped(Throwable cause) {
        return new TestResult(Status.SKIPPED, cause);
    }

    public static TestResult skipped(String description) {
        return new TestResult(Status.SKIPPED, description);
    }

    public static TestResult skipped() {
        return new TestResult(Status.SKIPPED);
    }

    public static TestResult failed(Throwable cause) {
        return new TestResult(Status.FAILED, cause);
    }

    public static TestResult flatten(Collection<TestResult> results) {
        TestResult combinedResult = new TestResult(Status.PASSED);
        HashMap<Status, TestResult> resultsPerStatus = new HashMap<Status, TestResult>();
        ArrayList<Throwable> allExceptions = new ArrayList<Throwable>();
        for (TestResult result : results) {
            resultsPerStatus.put(result.getStatus(), result);
            if (result.getThrowable() != null) {
                allExceptions.add(result.getThrowable());
            }
            combinedResult.addDescription(String.format("%s: '%s'%n", result.getStatus().name(), result.getDescription()));
        }
        TestResult.propagateTestResultStatus(combinedResult, resultsPerStatus);
        TestResult.propagateExceptions(combinedResult, allExceptions);
        return combinedResult;
    }

    private static void propagateExceptions(TestResult combinedResult, List<Throwable> allExceptions) {
        if (!allExceptions.isEmpty()) {
            switch (allExceptions.size()) {
                case 1: {
                    combinedResult.setThrowable(allExceptions.get(0));
                    break;
                }
                default: {
                    combinedResult.setThrowable(new CombinedException("Combined test result exceptions", allExceptions));
                }
            }
        }
    }

    private static void propagateTestResultStatus(TestResult combinedResult, Map<Status, TestResult> resultsPerStatus) {
        if (resultsPerStatus.containsKey((Object)Status.FAILED)) {
            combinedResult.setStatus(Status.FAILED);
        } else if (resultsPerStatus.containsKey((Object)Status.PASSED)) {
            combinedResult.setStatus(Status.PASSED);
        } else if (resultsPerStatus.containsKey((Object)Status.SKIPPED)) {
            combinedResult.setStatus(Status.SKIPPED);
        }
    }

    @Deprecated
    public TestResult(Status status, String description) {
        this(status);
        this.description = description;
    }

    @Deprecated
    public TestResult() {
        this(null);
    }

    @Deprecated
    public TestResult(Status status) {
        this(status, (Throwable)null);
    }

    @Deprecated
    public TestResult(Status status, Throwable throwable) {
        this.status = status;
        this.setThrowable(throwable);
        this.start = System.currentTimeMillis();
    }

    public Status getStatus() {
        return this.status;
    }

    @Deprecated
    public TestResult setStatus(Status status) {
        this.status = status;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public void setDescription(String description) {
        this.description = description;
    }

    public void addDescription(String description) {
        this.description = this.description + description;
    }

    public Throwable getThrowable() {
        if (this.throwable == null && this.exceptionProxy != null) {
            this.throwable = this.exceptionProxy.createException();
        }
        return this.throwable;
    }

    public TestResult setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.exceptionProxy = ExceptionProxy.createForException(throwable);
        return this;
    }

    public TestResult setStart(long start) {
        this.start = start;
        return this;
    }

    public long getStart() {
        return this.start;
    }

    public TestResult setEnd(long end) {
        this.end = end;
        return this;
    }

    public long getEnd() {
        return this.end;
    }

    public ExceptionProxy getExceptionProxy() {
        return this.exceptionProxy;
    }

    public String toString() {
        long time = this.end > 0L ? this.end - this.start : System.currentTimeMillis() - this.start;
        return "TestResult[status=" + (Object)((Object)this.status) + ",time=" + time + "ms]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        PASSED,
        FAILED,
        SKIPPED;

    }
}

